/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractStressTestBase;
import org.neo4j.driver.stress.AsyncCommand;
import org.neo4j.driver.stress.AsyncFailingQuery;
import org.neo4j.driver.stress.AsyncFailingQueryInTx;
import org.neo4j.driver.stress.AsyncReadQuery;
import org.neo4j.driver.stress.AsyncReadQueryInTx;
import org.neo4j.driver.stress.AsyncWriteQuery;
import org.neo4j.driver.stress.AsyncWriteQueryInTx;
import org.neo4j.driver.stress.AsyncWrongQuery;
import org.neo4j.driver.stress.AsyncWrongQueryInTx;
import org.neo4j.driver.stress.BlockingCommand;
import org.neo4j.driver.stress.BlockingFailingQuery;
import org.neo4j.driver.stress.BlockingFailingQueryInTx;
import org.neo4j.driver.stress.BlockingReadQuery;
import org.neo4j.driver.stress.BlockingReadQueryInTx;
import org.neo4j.driver.stress.BlockingWriteQuery;
import org.neo4j.driver.stress.BlockingWriteQueryInTx;
import org.neo4j.driver.stress.BlockingWrongQuery;
import org.neo4j.driver.stress.BlockingWrongQueryInTx;
import org.neo4j.driver.stress.RxCommand;
import org.neo4j.driver.stress.RxFailingQuery;
import org.neo4j.driver.stress.RxFailingQueryInTx;
import org.neo4j.driver.stress.RxReadQuery;
import org.neo4j.driver.stress.RxReadQueryInTx;
import org.neo4j.driver.stress.RxWriteQuery;
import org.neo4j.driver.stress.RxWriteQueryInTx;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class SingleInstanceStressIT
extends AbstractStressTestBase<Context> {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    SingleInstanceStressIT() {
    }

    @Override
    URI databaseUri() {
        return neo4j.uri();
    }

    @Override
    AuthToken authToken() {
        return neo4j.authToken();
    }

    @Override
    Config.ConfigBuilder config(Config.ConfigBuilder builder) {
        return builder.withoutEncryption();
    }

    @Override
    Context createContext() {
        return new Context();
    }

    @Override
    boolean handleWriteFailure(Throwable error, Context context) {
        return false;
    }

    @Override
    <A extends Context> void printStats(A context) {
        System.out.println("Nodes read: " + context.getReadNodesCount());
        System.out.println("Nodes created: " + context.getCreatedNodesCount());
        System.out.println("Bookmark failures: " + context.getBookmarkFailures());
    }

    @Override
    List<BlockingCommand<Context>> createTestSpecificBlockingCommands() {
        return Arrays.asList(new BlockingReadQuery((Driver)this.driver, false), new BlockingReadQuery((Driver)this.driver, true), new BlockingReadQueryInTx((Driver)this.driver, false), new BlockingReadQueryInTx((Driver)this.driver, true), new BlockingWriteQuery<Context>(this, (Driver)this.driver, false), new BlockingWriteQuery<Context>(this, (Driver)this.driver, true), new BlockingWriteQueryInTx<Context>(this, (Driver)this.driver, false), new BlockingWriteQueryInTx<Context>(this, (Driver)this.driver, true), new BlockingWrongQuery((Driver)this.driver), new BlockingWrongQueryInTx((Driver)this.driver), new BlockingFailingQuery((Driver)this.driver), new BlockingFailingQueryInTx((Driver)this.driver));
    }

    @Override
    List<AsyncCommand<Context>> createTestSpecificAsyncCommands() {
        return Arrays.asList(new AsyncReadQuery((Driver)this.driver, false), new AsyncReadQuery((Driver)this.driver, true), new AsyncReadQueryInTx((Driver)this.driver, false), new AsyncReadQueryInTx((Driver)this.driver, true), new AsyncWriteQuery<Context>(this, (Driver)this.driver, false), new AsyncWriteQuery<Context>(this, (Driver)this.driver, true), new AsyncWriteQueryInTx<Context>(this, (Driver)this.driver, false), new AsyncWriteQueryInTx<Context>(this, (Driver)this.driver, true), new AsyncWrongQuery((Driver)this.driver), new AsyncWrongQueryInTx((Driver)this.driver), new AsyncFailingQuery((Driver)this.driver), new AsyncFailingQueryInTx((Driver)this.driver));
    }

    @Override
    List<RxCommand<Context>> createTestSpecificRxCommands() {
        return Arrays.asList(new RxReadQuery((Driver)this.driver, false), new RxReadQuery((Driver)this.driver, true), new RxWriteQuery<Context>(this, (Driver)this.driver, false), new RxWriteQuery<Context>(this, (Driver)this.driver, true), new RxReadQueryInTx((Driver)this.driver, false), new RxReadQueryInTx((Driver)this.driver, true), new RxWriteQueryInTx<Context>(this, (Driver)this.driver, false), new RxWriteQueryInTx<Context>(this, (Driver)this.driver, true), new RxFailingQuery((Driver)this.driver), new RxFailingQueryInTx((Driver)this.driver));
    }

    static class Context
    extends AbstractContext {
        Context() {
        }
    }
}

