/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.tck.reactive;

import java.time.Duration;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Values;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.reactivestreams.Publisher;
import org.reactivestreams.tck.PublisherVerification;
import org.reactivestreams.tck.TestEnvironment;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Neo4jContainer;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;

@Testcontainers(disabledWithoutDocker=true)
public class RxResultRecordPublisherVerificationIT
extends PublisherVerification<Record> {
    private static final Neo4jContainer<?> NEO4J_CONTAINER = new Neo4jContainer("neo4j:4.4").withAdminPassword(null);
    private static final long MAX_NUMBER_OF_RECORDS = 30000L;
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration TIMEOUT_FOR_NO_SIGNALS = Duration.ofSeconds(1L);
    private static final Duration PUBLISHER_REFERENCE_CLEANUP_TIMEOUT_MILLIS = Duration.ofSeconds(1L);
    private static final String QUERY = "UNWIND RANGE(1, $numberOfRecords) AS n RETURN 'String Number' + n";
    private Driver driver;

    public RxResultRecordPublisherVerificationIT() {
        super(new TestEnvironment(TIMEOUT.toMillis(), TIMEOUT_FOR_NO_SIGNALS.toMillis()), PUBLISHER_REFERENCE_CLEANUP_TIMEOUT_MILLIS.toMillis());
    }

    @BeforeClass
    public void beforeClass() {
        if (!this.isDockerAvailable()) {
            throw new SkipException("Docker is unavailable");
        }
        NEO4J_CONTAINER.start();
        this.driver = GraphDatabase.driver((String)NEO4J_CONTAINER.getBoltUrl());
    }

    public void afterClass() {
        NEO4J_CONTAINER.stop();
    }

    public long maxElementsFromPublisher() {
        return 30000L;
    }

    public Publisher<Record> createPublisher(long elements) {
        RxSession session = this.driver.rxSession();
        RxResult result = session.run(QUERY, Values.parameters((Object[])new Object[]{"numberOfRecords", elements}));
        return result.records();
    }

    public Publisher<Record> createFailedPublisher() {
        RxSession session = this.driver.rxSession();
        RxResult result = session.run("INVALID");
        return result.records();
    }

    boolean isDockerAvailable() {
        try {
            DockerClientFactory.instance().client();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

