/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bouncycastle.asn1.x509.GeneralName;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.types.TypeSystem;
import org.neo4j.driver.util.CertificateUtil;
import org.neo4j.driver.util.Neo4jSettings;
import org.neo4j.driver.util.TestUtil;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Neo4jContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class DatabaseExtension
implements ExecutionCondition,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final int BOLT_PORT = 7687;
    private static final int HTTP_PORT = 7474;
    private static final boolean dockerAvailable = DatabaseExtension.isDockerAvailable();
    private static final DatabaseExtension instance = new DatabaseExtension();
    private static final URI boltUri;
    private static final URI httpUri;
    private static final AuthToken authToken;
    private static final File cert;
    private static final File key;
    private static final Network network;
    private static final GenericContainer<?> nginx;
    private static final Map<String, String> defaultConfig;
    private static Neo4jContainer<?> neo4jContainer;
    private static Driver driver;
    private static boolean nginxRunning;

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return dockerAvailable ? ConditionEvaluationResult.enabled((String)"Docker is available") : ConditionEvaluationResult.disabled((String)"Docker is unavailable");
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        TestUtil.cleanDb(driver);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (!nginxRunning) {
            this.startProxy();
        }
    }

    public void afterAll(ExtensionContext context) {
        this.deleteAndStartNeo4j(Collections.emptyMap());
    }

    public Driver driver() {
        return driver;
    }

    public TypeSystem typeSystem() {
        return driver.defaultTypeSystem();
    }

    public void deleteAndStartNeo4j(Map<String, String> config) {
        HashMap<String, String> updatedConfig = new HashMap<String, String>(defaultConfig);
        updatedConfig.putAll(config);
        neo4jContainer.stop();
        neo4jContainer = DatabaseExtension.setupNeo4jContainer(cert, key, updatedConfig);
        neo4jContainer.start();
        driver = Neo4jSettings.BoltTlsLevel.REQUIRED.toString().equals(config.get("dbms.connector.bolt.tls_level")) ? GraphDatabase.driver((URI)boltUri, (AuthToken)authToken, (Config)Config.builder().withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{cert})).withEncryption().build()) : GraphDatabase.driver((URI)boltUri, (AuthToken)authToken);
        DatabaseExtension.waitForBoltAvailability();
    }

    public String addImportFile(String prefix, String suffix, String contents) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix, null);
        tmpFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(tmpFile);){
            out.println(contents);
        }
        Path tmpFilePath = tmpFile.toPath();
        Path targetPath = Paths.get("/var/lib/neo4j/import", tmpFilePath.getFileName().toString());
        neo4jContainer.copyFileToContainer(MountableFile.forHostPath((Path)tmpFilePath), targetPath.toString());
        return String.format("file:///%s", tmpFile.getName());
    }

    public URI uri() {
        return boltUri;
    }

    public int httpPort() {
        return httpUri.getPort();
    }

    public int boltPort() {
        return boltUri.getPort();
    }

    public AuthToken authToken() {
        return authToken;
    }

    public String adminPassword() {
        return neo4jContainer.getAdminPassword();
    }

    public BoltServerAddress address() {
        return new BoltServerAddress(boltUri);
    }

    public void updateEncryptionKeyAndCert(File key, File cert) {
        System.out.println("Updated neo4j key and certificate file.");
        neo4jContainer.stop();
        neo4jContainer = DatabaseExtension.setupNeo4jContainer(cert, key, defaultConfig);
        neo4jContainer.start();
        driver = GraphDatabase.driver((URI)boltUri, (AuthToken)authToken);
        DatabaseExtension.waitForBoltAvailability();
    }

    public File tlsCertFile() {
        return cert;
    }

    public void startProxy() {
        try {
            nginx.execInContainer(new String[]{"nginx"});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        nginxRunning = true;
    }

    public void stopProxy() {
        try {
            nginx.execInContainer(new String[]{"nginx", "-s", "stop"});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        nginxRunning = false;
    }

    public boolean isNeo4j44OrEarlier() {
        return this.isNeo4jVersionOrEarlier(4, 4);
    }

    private boolean isNeo4jVersionOrEarlier(int major, int minor) {
        try (Session session = driver.session();){
            String neo4jVersion = (String)session.readTransaction(tx -> tx.run("CALL dbms.components() YIELD versions RETURN versions[0] AS version").single().get("version").asString());
            String[] versions = neo4jVersion.split("\\.");
            boolean bl = Integer.parseInt(versions[0]) <= major && Integer.parseInt(versions[1]) <= minor;
            return bl;
        }
    }

    public static DatabaseExtension getInstance() {
        return instance;
    }

    public static GeneralName getDockerHostGeneralName() {
        GeneralName generalName;
        String host = DockerClientFactory.instance().dockerHostIpAddress();
        try {
            generalName = new GeneralName(7, host);
        }
        catch (IllegalArgumentException e) {
            generalName = new GeneralName(2, host);
        }
        return generalName;
    }

    private static CertificateUtil.CertificateKeyPair<File, File> generateCertificateAndKey() {
        try {
            return CertificateUtil.createNewCertificateAndKey(DatabaseExtension.getDockerHostGeneralName());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Neo4jContainer<?> setupNeo4jContainer(File cert, File key, Map<String, String> config) {
        String neo4JVersion = Optional.ofNullable(System.getenv("NEO4J_VERSION")).orElse("4.4");
        ImageFromDockerfile extendedNeo4jImage = (ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(String.format("neo4j:%s-enterprise", neo4JVersion))).run("mkdir /var/lib/neo4j/certificates/bolt")).copy("public.crt", "/var/lib/neo4j/certificates/bolt/")).copy("private.key", "/var/lib/neo4j/certificates/bolt/")).build())).withFileFromPath("public.crt", cert.toPath())).withFileFromPath("private.key", key.toPath());
        DockerImageName extendedNeo4jImageAsSubstitute = DockerImageName.parse((String)((String)extendedNeo4jImage.get())).asCompatibleSubstituteFor("neo4j");
        neo4jContainer = (Neo4jContainer)((Neo4jContainer)((Neo4jContainer)new Neo4jContainer(extendedNeo4jImageAsSubstitute).withEnv("NEO4J_ACCEPT_LICENSE_AGREEMENT", "yes")).withNetwork(network)).withNetworkAliases(new String[]{"neo4j"});
        for (Map.Entry<String, String> entry : config.entrySet()) {
            neo4jContainer.withNeo4jConfig(entry.getKey(), entry.getValue());
        }
        return neo4jContainer;
    }

    private static GenericContainer<?> setupNginxContainer() {
        ImageFromDockerfile extendedNginxImage = (ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)builder.from("nginx:1.23.0-alpine")).copy("nginx.conf", "/etc/nginx/")).build())).withFileFromClasspath("nginx.conf", "nginx.conf");
        return new GenericContainer((String)extendedNginxImage.get()).withNetwork(network).withExposedPorts(new Integer[]{7687, 7474}).withCommand(new String[]{"sh", "-c", "nginx && while sleep 3600; do :; done"});
    }

    private static void waitForBoltAvailability() {
        int maxAttempts = 600;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            try {
                driver.verifyConnectivity();
                return;
            }
            catch (RuntimeException verificationException) {
                if (attempt == maxAttempts - 1) {
                    throw new RuntimeException("Timed out waiting for Neo4j to become available over Bolt", verificationException);
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.addSuppressed(verificationException);
                    throw new RuntimeException("Interrupted while waiting for Neo4j to become available over Bolt", interruptedException);
                }
            }
        }
    }

    private static boolean isDockerAvailable() {
        try {
            DockerClientFactory.instance().client();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        defaultConfig = new HashMap<String, String>();
        defaultConfig.put("dbms.ssl.policy.bolt.enabled", "true");
        defaultConfig.put("dbms.ssl.policy.bolt.client_auth", "NONE");
        defaultConfig.put("dbms.connector.bolt.tls_level", Neo4jSettings.BoltTlsLevel.OPTIONAL.toString());
        if (dockerAvailable) {
            CertificateUtil.CertificateKeyPair<File, File> pair = DatabaseExtension.generateCertificateAndKey();
            cert = pair.cert();
            key = pair.key();
            network = Network.newNetwork();
            neo4jContainer = DatabaseExtension.setupNeo4jContainer(cert, key, defaultConfig);
            neo4jContainer.start();
            nginx = DatabaseExtension.setupNginxContainer();
            nginx.start();
            nginxRunning = true;
            URI neo4jBoltUri = URI.create(neo4jContainer.getBoltUrl());
            URI neo4jHttpUri = URI.create(neo4jContainer.getHttpUrl());
            boltUri = URI.create(String.format("%s://%s:%d", neo4jBoltUri.getScheme(), neo4jBoltUri.getHost(), nginx.getMappedPort(7687)));
            httpUri = URI.create(String.format("%s://%s:%d", neo4jHttpUri.getScheme(), neo4jHttpUri.getHost(), nginx.getMappedPort(7474)));
            authToken = AuthTokens.basic((String)"neo4j", (String)neo4jContainer.getAdminPassword());
            driver = GraphDatabase.driver((URI)boltUri, (AuthToken)authToken);
            DatabaseExtension.waitForBoltAvailability();
        } else {
            boltUri = URI.create("");
            httpUri = URI.create("");
            authToken = AuthTokens.none();
            cert = new File("");
            key = new File("");
            network = null;
            nginx = new GenericContainer(DockerImageName.parse((String)"alpine:latest"));
        }
    }
}

