/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.Session;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.TestUtil;

public class DriverExtension
extends DatabaseExtension
implements BeforeEachCallback,
AfterEachCallback {
    private AsyncSession asyncSession;
    private Session session;

    public AsyncSession asyncSession() {
        return this.asyncSession;
    }

    public Session session() {
        return this.session;
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        super.beforeEach(context);
        this.asyncSession = this.driver().asyncSession();
        this.session = this.driver().session();
    }

    @Override
    public void afterEach(ExtensionContext context) {
        if (this.asyncSession != null) {
            TestUtil.await(this.asyncSession.closeAsync());
        }
        if (this.session != null) {
            this.session.close();
        }
    }
}

