/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.internal.util.Iterables;

public class Neo4jSettings {
    public static final String DATA_DIR = "dbms.directories.data";
    public static final String IMPORT_DIR = "dbms.directories.import";
    public static final String SSL_POLICY_BOLT_ENABLED = "dbms.ssl.policy.bolt.enabled";
    public static final String SSL_POLICY_BOLT_CLIENT_AUTH = "dbms.ssl.policy.bolt.client_auth";
    public static final String LISTEN_ADDR = "dbms.default_listen_address";
    public static final String IPV6_ENABLED_ADDR = "::";
    public static final String BOLT_TLS_LEVEL = "dbms.connector.bolt.tls_level";
    private static final String DEFAULT_IMPORT_DIR = "import";
    public static final String DEFAULT_BOLT_TLS_LEVEL = BoltTlsLevel.OPTIONAL.toString();
    public static final String DEFAULT_DATA_DIR = "data";
    static final int TEST_JVM_ID = Integer.getInteger("testJvmId", 0);
    private static final int DEFAULT_HTTP_PORT = 12000;
    private static final int DEFAULT_HTTPS_PORT = 13000;
    private static final int DEFAULT_BOLT_PORT = 14000;
    private static final int DEFAULT_DISCOVERY_LISTEN_PORT = 15000;
    private static final int DEFAULT_RAFT_ADVERTISED_PORT = 16000;
    private static final int DEFAULT_TX_LISTEN_PORT = 17000;
    static final int CURRENT_HTTP_PORT = 12000 + TEST_JVM_ID;
    private static final int CURRENT_HTTPS_PORT = 13000 + TEST_JVM_ID;
    static final int CURRENT_BOLT_PORT = 14000 + TEST_JVM_ID;
    static final int CURRENT_DISCOVERY_LISTEN_PORT = 15000 + TEST_JVM_ID;
    static final int CURRENT_RAFT_ADVERTISED_PORT = 16000 + TEST_JVM_ID;
    static final int CURRENT_TX_LISTEN_PORT = 17000 + TEST_JVM_ID;
    private static final String WINDOWS_SERVICE_NAME = "neo4j-" + TEST_JVM_ID;
    private final Map<String, String> settings;
    private final Set<String> excludes;
    public static final Neo4jSettings TEST_SETTINGS = new Neo4jSettings(Iterables.map((String[])new String[]{"dbms.connector.http.listen_address", ":" + CURRENT_HTTP_PORT, "dbms.connector.https.listen_address", ":" + CURRENT_HTTPS_PORT, "dbms.connector.bolt.listen_address", ":" + CURRENT_BOLT_PORT, "dbms.cluster.discovery.initial_members", "localhost:" + CURRENT_DISCOVERY_LISTEN_PORT, "server.discovery.listen_address", ":" + CURRENT_DISCOVERY_LISTEN_PORT, "cluster.raft_advertised_address", ":" + CURRENT_RAFT_ADVERTISED_PORT, "cluster.raft_listen_address", ":" + CURRENT_RAFT_ADVERTISED_PORT, "cluster.transaction_listen_address", ":" + CURRENT_TX_LISTEN_PORT, "cluster.transaction_advertised_address", ":" + CURRENT_TX_LISTEN_PORT, "server.cluster.advertised_address", ":" + CURRENT_TX_LISTEN_PORT, "dbms.windows_service_name", WINDOWS_SERVICE_NAME, "dbms.directories.data", "data", "dbms.directories.import", "import", "dbms.connector.bolt.tls_level", DEFAULT_BOLT_TLS_LEVEL, "dbms.default_listen_address", "::"}), Collections.emptySet());

    private Neo4jSettings(Map<String, String> settings, Set<String> excludes) {
        this.settings = settings;
        this.excludes = excludes;
    }

    public Map<String, String> propertiesMap() {
        return this.settings;
    }

    public Neo4jSettings without(String key) {
        HashSet<String> newExcludes = new HashSet<String>(this.excludes);
        newExcludes.add(key);
        HashMap<String, String> newMap = new HashMap<String, String>(this.settings);
        newMap.remove(key);
        Neo4jSettings newSettings = new Neo4jSettings(newMap, newExcludes);
        return newSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Neo4jSettings that = (Neo4jSettings)o;
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return this.excludes.equals(that.excludes);
    }

    public int hashCode() {
        return this.settings.hashCode();
    }

    public Set<String> excludes() {
        return this.excludes;
    }

    public static enum BoltTlsLevel {
        OPTIONAL,
        REQUIRED,
        DISABLED;

    }
}

