/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.util.Map;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.Value;
import org.neo4j.driver.util.DatabaseExtension;

public class SessionExtension
extends DatabaseExtension
implements Session,
BeforeEachCallback,
AfterEachCallback {
    private Session realSession;

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        super.beforeEach(context);
        this.realSession = this.driver().session();
    }

    @Override
    public void afterEach(ExtensionContext context) {
        if (this.realSession != null) {
            this.realSession.close();
        }
    }

    public boolean isOpen() {
        return this.realSession.isOpen();
    }

    public void close() {
        throw new UnsupportedOperationException("Disallowed on this test session");
    }

    public Transaction beginTransaction() {
        return this.realSession.beginTransaction();
    }

    public Transaction beginTransaction(TransactionConfig config) {
        return this.realSession.beginTransaction(config);
    }

    public <T> T readTransaction(TransactionWork<T> work) {
        return (T)this.realSession.readTransaction(work);
    }

    public <T> T readTransaction(TransactionWork<T> work, TransactionConfig config) {
        return (T)this.realSession.readTransaction(work, config);
    }

    public <T> T writeTransaction(TransactionWork<T> work) {
        return (T)this.realSession.writeTransaction(work);
    }

    public <T> T writeTransaction(TransactionWork<T> work, TransactionConfig config) {
        return (T)this.realSession.writeTransaction(work, config);
    }

    public Bookmark lastBookmark() {
        return this.realSession.lastBookmark();
    }

    @Deprecated
    public void reset() {
        this.realSession.reset();
    }

    public Result run(String query, Map<String, Object> parameters) {
        return this.realSession.run(query, parameters);
    }

    public Result run(String query, Value parameters) {
        return this.realSession.run(query, parameters);
    }

    public Result run(String query, Record parameters) {
        return this.realSession.run(query, parameters);
    }

    public Result run(String query) {
        return this.realSession.run(query);
    }

    public Result run(Query query) {
        return this.realSession.run(query.text(), query.parameters());
    }

    public Result run(String query, TransactionConfig config) {
        return this.realSession.run(query, config);
    }

    public Result run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.realSession.run(query, parameters, config);
    }

    public Result run(Query query, TransactionConfig config) {
        return this.realSession.run(query, config);
    }
}

