/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.types.IsoDuration;

public final class TemporalUtil {
    private static final List<String> EXCLUDED_ZONE_IDS = Arrays.asList("Canada/East-Saskatchewan", "Chile/EasterIsland", "Africa/Casablanca", "tzid", "Asia/Qostanay", "America/Santiago", "US/Pacific-New", "Pacific/Easter", "America/Ciudad_Juarez", "Europe/Kyiv");

    private TemporalUtil() {
    }

    public static LocalDate randomLocalDate() {
        return LocalDate.of(TemporalUtil.random(ChronoField.YEAR), TemporalUtil.random(ChronoField.MONTH_OF_YEAR), TemporalUtil.random(ChronoField.DAY_OF_MONTH));
    }

    public static OffsetTime randomOffsetTime() {
        ZoneOffset offset = TemporalUtil.randomZoneOffset();
        return OffsetTime.of(TemporalUtil.random(ChronoField.HOUR_OF_DAY), TemporalUtil.random(ChronoField.MINUTE_OF_HOUR), TemporalUtil.random(ChronoField.SECOND_OF_MINUTE), TemporalUtil.random(ChronoField.NANO_OF_SECOND), offset);
    }

    public static LocalTime randomLocalTime() {
        return LocalTime.of(TemporalUtil.random(ChronoField.HOUR_OF_DAY), TemporalUtil.random(ChronoField.MINUTE_OF_HOUR), TemporalUtil.random(ChronoField.SECOND_OF_MINUTE), TemporalUtil.random(ChronoField.NANO_OF_SECOND));
    }

    public static LocalDateTime randomLocalDateTime() {
        return LocalDateTime.of(TemporalUtil.random(ChronoField.YEAR), TemporalUtil.random(ChronoField.MONTH_OF_YEAR), TemporalUtil.random(ChronoField.DAY_OF_MONTH), TemporalUtil.random(ChronoField.HOUR_OF_DAY), TemporalUtil.random(ChronoField.MINUTE_OF_HOUR), TemporalUtil.random(ChronoField.SECOND_OF_MINUTE), TemporalUtil.random(ChronoField.NANO_OF_SECOND));
    }

    public static OffsetDateTime randomOffsetDateTime() {
        return TemporalUtil.randomZonedDateTimeWithOffset().toOffsetDateTime();
    }

    public static ZonedDateTime randomZonedDateTimeWithOffset() {
        return TemporalUtil.randomZonedDateTime(TemporalUtil.randomZoneOffset());
    }

    public static ZonedDateTime randomZonedDateTimeWithZoneId() {
        return TemporalUtil.randomZonedDateTime(TemporalUtil.randomZoneId());
    }

    public static IsoDuration randomDuration() {
        int sign = TemporalUtil.random().nextBoolean() ? 1 : -1;
        return new InternalIsoDuration((long)(sign * TemporalUtil.randomInt()), (long)(sign * TemporalUtil.randomInt()), (long)(sign * TemporalUtil.randomInt()), Math.abs(TemporalUtil.random(ChronoField.NANO_OF_SECOND)));
    }

    private static ZonedDateTime randomZonedDateTime(ZoneId zoneId) {
        return ZonedDateTime.of(TemporalUtil.random(ChronoField.YEAR), TemporalUtil.random(ChronoField.MONTH_OF_YEAR), TemporalUtil.random(ChronoField.DAY_OF_MONTH), TemporalUtil.random(ChronoField.HOUR_OF_DAY), TemporalUtil.random(ChronoField.MINUTE_OF_HOUR), TemporalUtil.random(ChronoField.SECOND_OF_MINUTE), TemporalUtil.random(ChronoField.NANO_OF_SECOND), zoneId);
    }

    private static ZoneOffset randomZoneOffset() {
        int min = ZoneOffset.MIN.getTotalSeconds();
        int max = ZoneOffset.MAX.getTotalSeconds();
        return ZoneOffset.ofTotalSeconds(TemporalUtil.random().nextInt(min, max));
    }

    private static ZoneId randomZoneId() {
        Set availableZoneIds = ZoneId.getAvailableZoneIds().stream().filter(id -> !EXCLUDED_ZONE_IDS.contains(id)).collect(Collectors.toSet());
        int randomIndex = TemporalUtil.random().nextInt(availableZoneIds.size());
        int index = 0;
        for (String id2 : availableZoneIds) {
            if (index == randomIndex) {
                return ZoneId.of(id2);
            }
            ++index;
        }
        throw new AssertionError((Object)("Unable to pick random ZoneId from the set of available ids: " + availableZoneIds));
    }

    private static int random(ChronoField field) {
        ValueRange range = field.range();
        long min = range.getMinimum();
        long max = range.getSmallestMaximum();
        long value = TemporalUtil.random().nextLong(min, max);
        return Math.toIntExact(value);
    }

    private static int randomInt() {
        return TemporalUtil.random().nextInt(0, Integer.MAX_VALUE);
    }

    private static ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }
}

