/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.net.URI;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.util.TestUtil;
import org.testcontainers.containers.Neo4jContainer;

public class LocalOrRemoteClusterExtension
implements BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private static final String CLUSTER_URI_SYSTEM_PROPERTY_NAME = "externalClusterUri";
    private static final String NEO4J_USER_PASSWORD_PROPERTY_NAME = "neo4jUserPassword";
    private Neo4jContainer<?> neo4jContainer;
    private URI clusterUri;

    public LocalOrRemoteClusterExtension() {
        LocalOrRemoteClusterExtension.assertValidSystemPropertiesDefined();
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    public AuthToken getAuthToken() {
        if (LocalOrRemoteClusterExtension.remoteClusterExists()) {
            return AuthTokens.basic((String)"neo4j", (String)LocalOrRemoteClusterExtension.neo4jUserPasswordFromSystemProperty());
        }
        return AuthTokens.basic((String)"neo4j", (String)this.neo4jContainer.getAdminPassword());
    }

    public void beforeAll(ExtensionContext context) {
        if (LocalOrRemoteClusterExtension.remoteClusterExists()) {
            this.clusterUri = LocalOrRemoteClusterExtension.remoteClusterUriFromSystemProperty();
            this.cleanDb();
        } else {
            String neo4JVersion = Optional.ofNullable(System.getenv("NEO4J_VERSION")).orElse("4.4");
            this.neo4jContainer = (Neo4jContainer)new Neo4jContainer(String.format("neo4j:%s-enterprise", neo4JVersion)).withEnv("NEO4J_ACCEPT_LICENSE_AGREEMENT", "yes");
            this.neo4jContainer.start();
            this.clusterUri = URI.create(this.neo4jContainer.getBoltUrl().replace("bolt://", "neo4j://"));
        }
    }

    public void afterEach(ExtensionContext context) {
        this.cleanDb();
    }

    public void afterAll(ExtensionContext context) {
        if (!LocalOrRemoteClusterExtension.remoteClusterExists()) {
            this.neo4jContainer.stop();
        }
    }

    private void cleanDb() {
        Config.ConfigBuilder builder = Config.builder();
        builder.withEventLoopThreads(1);
        try (Driver driver = GraphDatabase.driver((URI)this.getClusterUri(), (AuthToken)this.getAuthToken(), (Config)builder.build());){
            TestUtil.cleanDb(driver);
        }
    }

    private static void assertValidSystemPropertiesDefined() {
        URI uri = LocalOrRemoteClusterExtension.remoteClusterUriFromSystemProperty();
        String password = LocalOrRemoteClusterExtension.neo4jUserPasswordFromSystemProperty();
        if (uri != null && password == null || uri == null && password != null) {
            throw new IllegalStateException("Both cluster uri and 'neo4j' user password system properties should be set. Uri: '" + uri + "', Password: '" + password + "'");
        }
    }

    private static boolean remoteClusterExists() {
        return LocalOrRemoteClusterExtension.remoteClusterUriFromSystemProperty() != null;
    }

    private static URI remoteClusterUriFromSystemProperty() {
        String uri = System.getProperty(CLUSTER_URI_SYSTEM_PROPERTY_NAME);
        return uri == null ? null : URI.create(uri);
    }

    private static String neo4jUserPasswordFromSystemProperty() {
        return System.getProperty(NEO4J_USER_PASSWORD_PROPERTY_NAME);
    }
}

