/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.util.ServerVersion;

public class InitResponseHandler
implements ResponseHandler {
    private final ChannelPromise connectionInitializedPromise;
    private final Channel channel;

    public InitResponseHandler(ChannelPromise connectionInitializedPromise) {
        this.connectionInitializedPromise = connectionInitializedPromise;
        this.channel = connectionInitializedPromise.channel();
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            ServerVersion serverVersion = MetadataExtractor.extractNeo4jServerVersion(metadata);
            ChannelAttributes.setServerVersion(this.channel, serverVersion);
            this.connectionInitializedPromise.setSuccess();
        }
        catch (Throwable error) {
            this.connectionInitializedPromise.setFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener(future -> this.connectionInitializedPromise.setFailure(error));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }
}

