/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.actuate;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.function.Consumer;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.exceptions.ClientException;
import org.springframework.util.Assert;

public final class Neo4jDriverMetrics
implements MeterBinder {
    public static final String PREFIX = "neo4j.driver.connections";
    private static final String BASE_UNIT_CONNECTIONS = "connections";
    private final Driver driver;
    private final Iterable<Tag> tags;

    public Neo4jDriverMetrics(String name, Driver driver, Iterable<Tag> tags) {
        Assert.notNull((Object)name, (String)"Bean name must not be null");
        Assert.notNull((Object)driver, (String)"Driver must not be null");
        Assert.notNull(tags, (String)"Tags must not be null (but may be empty)");
        this.driver = driver;
        this.tags = Tags.concat(tags, (String[])new String[]{"name", name});
    }

    public void bindTo(MeterRegistry meterRegistry) {
        Metrics metrics = this.driver.metrics();
        metrics.connectionPoolMetrics().forEach(this.getPoolMetricsBinder(meterRegistry));
    }

    Consumer<ConnectionPoolMetrics> getPoolMetricsBinder(MeterRegistry meterRegistry) {
        return poolMetrics -> {
            Tags poolTags = Tags.concat(this.tags, (String[])new String[]{"poolId", poolMetrics.id()});
            FunctionCounter.builder((String)"neo4j.driver.connections.acquired", (Object)poolMetrics, ConnectionPoolMetrics::acquired).tags((Iterable)poolTags).baseUnit(BASE_UNIT_CONNECTIONS).description("The amount of connections that have been acquired.").register(meterRegistry);
            FunctionCounter.builder((String)"neo4j.driver.connections.closed", (Object)poolMetrics, ConnectionPoolMetrics::closed).tags((Iterable)poolTags).baseUnit(BASE_UNIT_CONNECTIONS).description("The amount of connections have been closed.").register(meterRegistry);
            FunctionCounter.builder((String)"neo4j.driver.connections.created", (Object)poolMetrics, ConnectionPoolMetrics::created).tags((Iterable)poolTags).baseUnit(BASE_UNIT_CONNECTIONS).description("The amount of connections have ever been created.").register(meterRegistry);
            FunctionCounter.builder((String)"neo4j.driver.connections.failedToCreate", (Object)poolMetrics, ConnectionPoolMetrics::failedToCreate).tags((Iterable)poolTags).baseUnit(BASE_UNIT_CONNECTIONS).description("The amount of connections have been failed to create.").register(meterRegistry);
            Gauge.builder((String)"neo4j.driver.connections.idle", (Object)poolMetrics, ConnectionPoolMetrics::idle).tags((Iterable)poolTags).baseUnit(BASE_UNIT_CONNECTIONS).description("The amount of connections that are currently idle.").register(meterRegistry);
            Gauge.builder((String)"neo4j.driver.connections.inUse", (Object)poolMetrics, ConnectionPoolMetrics::inUse).tags((Iterable)poolTags).baseUnit(BASE_UNIT_CONNECTIONS).description("The amount of connections that are currently in-use.").register(meterRegistry);
            FunctionCounter.builder((String)"neo4j.driver.connections.timedOutToAcquire", (Object)poolMetrics, ConnectionPoolMetrics::timedOutToAcquire).tags((Iterable)poolTags).baseUnit(BASE_UNIT_CONNECTIONS).description("The amount of failures to acquire a connection from a pool within maximum connection acquisition timeout.").register(meterRegistry);
        };
    }

    public static boolean metricsAreEnabled(Driver driver) {
        try {
            driver.metrics();
            return true;
        }
        catch (ClientException e) {
            return false;
        }
    }
}

