/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.autoconfigure;

import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.net.ServerAddressResolver;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jSpringJclLogging;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="org.neo4j.driver")
public class Neo4jDriverProperties {
    private URI uri = URI.create("bolt://localhost:7687");
    private Authentication authentication = new Authentication();
    private PoolSettings pool = new PoolSettings();
    private DriverSettings config = new DriverSettings();

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public PoolSettings getPool() {
        return this.pool;
    }

    public void setPool(PoolSettings pool) {
        this.pool = pool;
    }

    public DriverSettings getConfig() {
        return this.config;
    }

    public void setConfig(DriverSettings config) {
        this.config = config;
    }

    public AuthToken getAuthToken() {
        return this.authentication.asAuthToken();
    }

    public Config asDriverConfig() {
        Config.ConfigBuilder builder = Config.builder();
        this.pool.applyTo(builder);
        this.config.applyTo(builder);
        return builder.withLogging((Logging)new Neo4jSpringJclLogging()).build();
    }

    public static class TrustSettings {
        private Strategy strategy = Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;
        private File certFile;
        private boolean hostnameVerificationEnabled = false;

        public Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(Strategy strategy) {
            this.strategy = strategy;
        }

        public File getCertFile() {
            return this.certFile;
        }

        public void setCertFile(File certFile) {
            this.certFile = certFile;
        }

        public boolean isHostnameVerificationEnabled() {
            return this.hostnameVerificationEnabled;
        }

        public void setHostnameVerificationEnabled(boolean hostnameVerificationEnabled) {
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
        }

        Config.TrustStrategy toInternalRepresentation() {
            Config.TrustStrategy internalRepresentation;
            String propertyName = "org.neo4j.driver.config.trust-settings";
            switch (this.strategy) {
                case TRUST_ALL_CERTIFICATES: {
                    internalRepresentation = Config.TrustStrategy.trustAllCertificates();
                    break;
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    internalRepresentation = Config.TrustStrategy.trustSystemCertificates();
                    break;
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    if (this.certFile == null || !this.certFile.isFile()) {
                        throw new InvalidConfigurationPropertyValueException(propertyName, (Object)this.strategy.name(), "Configured trust strategy requires a certificate file.");
                    }
                    internalRepresentation = Config.TrustStrategy.trustCustomCertificateSignedBy((File)this.certFile);
                    break;
                }
                default: {
                    throw new InvalidConfigurationPropertyValueException(propertyName, (Object)this.strategy.name(), "Unknown strategy.");
                }
            }
            if (this.hostnameVerificationEnabled) {
                internalRepresentation.withHostnameVerification();
            } else {
                internalRepresentation.withoutHostnameVerification();
            }
            return internalRepresentation;
        }

        public static enum Strategy {
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }

    public static class DriverSettings {
        private boolean encrypted = false;
        private TrustSettings trustSettings = new TrustSettings();
        private Duration connectionTimeout = Duration.ofSeconds(30L);
        private Duration maxTransactionRetryTime = Duration.ofMillis(RetrySettings.DEFAULT.maxRetryTimeMs());
        private Class<? extends ServerAddressResolver> serverAddressResolverClass;

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public void setEncrypted(boolean encrypted) {
            this.encrypted = encrypted;
        }

        public TrustSettings getTrustSettings() {
            return this.trustSettings;
        }

        public void setTrustSettings(TrustSettings trustSettings) {
            this.trustSettings = trustSettings;
        }

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public Duration getMaxTransactionRetryTime() {
            return this.maxTransactionRetryTime;
        }

        public void setMaxTransactionRetryTime(Duration maxTransactionRetryTime) {
            this.maxTransactionRetryTime = maxTransactionRetryTime;
        }

        public Class<? extends ServerAddressResolver> getServerAddressResolverClass() {
            return this.serverAddressResolverClass;
        }

        public void setServerAddressResolverClass(Class<? extends ServerAddressResolver> serverAddressResolverClass) {
            this.serverAddressResolverClass = serverAddressResolverClass;
        }

        private void applyTo(Config.ConfigBuilder builder) {
            if (this.encrypted) {
                builder.withEncryption();
            } else {
                builder.withoutEncryption();
            }
            builder.withTrustStrategy(this.trustSettings.toInternalRepresentation());
            builder.withConnectionTimeout(this.connectionTimeout.toMillis(), TimeUnit.MILLISECONDS);
            builder.withMaxTransactionRetryTime(this.maxTransactionRetryTime.toMillis(), TimeUnit.MILLISECONDS);
            if (this.serverAddressResolverClass != null) {
                builder.withResolver((ServerAddressResolver)BeanUtils.instantiateClass(this.serverAddressResolverClass));
            }
        }
    }

    public static class PoolSettings {
        private boolean metricsEnabled = false;
        private boolean logLeakedSessions = false;
        private int maxConnectionPoolSize = 100;
        private Duration idleTimeBeforeConnectionTest;
        private Duration maxConnectionLifetime = Duration.ofMillis(org.neo4j.driver.internal.async.pool.PoolSettings.DEFAULT_MAX_CONNECTION_LIFETIME);
        private Duration connectionAcquisitionTimeout = Duration.ofMillis(org.neo4j.driver.internal.async.pool.PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT);

        public boolean isLogLeakedSessions() {
            return this.logLeakedSessions;
        }

        public void setLogLeakedSessions(boolean logLeakedSessions) {
            this.logLeakedSessions = logLeakedSessions;
        }

        public int getMaxConnectionPoolSize() {
            return this.maxConnectionPoolSize;
        }

        public void setMaxConnectionPoolSize(int maxConnectionPoolSize) {
            this.maxConnectionPoolSize = maxConnectionPoolSize;
        }

        public Duration getIdleTimeBeforeConnectionTest() {
            return this.idleTimeBeforeConnectionTest;
        }

        public void setIdleTimeBeforeConnectionTest(Duration idleTimeBeforeConnectionTest) {
            this.idleTimeBeforeConnectionTest = idleTimeBeforeConnectionTest;
        }

        public Duration getMaxConnectionLifetime() {
            return this.maxConnectionLifetime;
        }

        public void setMaxConnectionLifetime(Duration maxConnectionLifetime) {
            this.maxConnectionLifetime = maxConnectionLifetime;
        }

        public Duration getConnectionAcquisitionTimeout() {
            return this.connectionAcquisitionTimeout;
        }

        public void setConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            this.connectionAcquisitionTimeout = connectionAcquisitionTimeout;
        }

        public boolean isMetricsEnabled() {
            return this.metricsEnabled;
        }

        public void setMetricsEnabled(boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
        }

        private void applyTo(Config.ConfigBuilder builder) {
            if (this.logLeakedSessions) {
                builder.withLeakedSessionsLogging();
            }
            builder.withMaxConnectionPoolSize(this.maxConnectionPoolSize);
            if (this.idleTimeBeforeConnectionTest != null) {
                builder.withConnectionLivenessCheckTimeout(this.idleTimeBeforeConnectionTest.toMillis(), TimeUnit.MILLISECONDS);
            }
            builder.withMaxConnectionLifetime(this.maxConnectionLifetime.toMillis(), TimeUnit.MILLISECONDS);
            builder.withConnectionAcquisitionTimeout(this.connectionAcquisitionTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (this.metricsEnabled) {
                builder.withDriverMetrics();
            } else {
                builder.withoutDriverMetrics();
            }
        }
    }

    public static class Authentication {
        private String username;
        private String password;
        private String realm;
        private String kerberosTicket;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public String getKerberosTicket() {
            return this.kerberosTicket;
        }

        public void setKerberosTicket(String kerberosTicket) {
            this.kerberosTicket = kerberosTicket;
        }

        AuthToken asAuthToken() {
            boolean hasUsername = StringUtils.hasText((String)this.username);
            boolean hasPassword = StringUtils.hasText((String)this.password);
            boolean hasKerberosTicket = StringUtils.hasText((String)this.kerberosTicket);
            if (hasUsername && hasKerberosTicket) {
                throw new InvalidConfigurationPropertyValueException("org.neo4j.driver.authentication", (Object)("username=" + this.username + ",kerberos-ticket=" + this.kerberosTicket), "Cannot specify both username and kerberos ticket.");
            }
            if (hasUsername && hasPassword) {
                return AuthTokens.basic((String)this.username, (String)this.password, (String)this.realm);
            }
            if (hasKerberosTicket) {
                return AuthTokens.kerberos((String)this.kerberosTicket);
            }
            return AuthTokens.none();
        }
    }
}

