/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Driver;
import org.neo4j.driver.springframework.boot.actuate.Neo4jDriverMetrics;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jDriverAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, Neo4jDriverAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={Driver.class, MeterRegistry.class})
@ConditionalOnBean(value={Driver.class, MeterRegistry.class})
public class Neo4jDriverMetricsAutoConfiguration {
    private static final Log logger = LogFactory.getLog(Neo4jDriverMetricsAutoConfiguration.class);

    @Autowired
    public void bindDataSourcesToRegistry(Map<String, Driver> drivers, MeterRegistry registry) {
        drivers.forEach((name, driver) -> {
            if (!Neo4jDriverMetrics.metricsAreEnabled(driver)) {
                return;
            }
            driver.verifyConnectivityAsync().thenRunAsync(() -> new Neo4jDriverMetrics((String)name, (Driver)driver, (Iterable<Tag>)Collections.emptyList()).bindTo(registry)).exceptionally(e -> {
                logger.warn((Object)("Could not verify connection for " + driver + " and thus not bind to metrics: " + e.getMessage()));
                return null;
            });
        });
    }
}

