/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.actuate;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Driver;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransactionWork;
import org.neo4j.driver.springframework.boot.actuate.Neo4jHealthIndicator;
import org.neo4j.driver.springframework.boot.actuate.ResultSummaryWithEdition;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Neo4jReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final Log logger = LogFactory.getLog(Neo4jReactiveHealthIndicator.class);
    private final Driver driver;

    public Neo4jReactiveHealthIndicator(Driver driver) {
        this.driver = driver;
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.runHealthCheckQuery().doOnError(SessionExpiredException.class, e -> logger.warn((Object)"Neo4j session has expired, retrying one single time to retrieve server health.")).retry(1L, SessionExpiredException.class::isInstance).map(r -> Neo4jHealthIndicator.buildStatusUp(r, builder).build());
    }

    Mono<ResultSummaryWithEdition> runHealthCheckQuery() {
        RxTransactionWork txFunction = tx -> {
            RxResult result = tx.run("CALL dbms.components() YIELD name, edition WHERE name = 'Neo4j Kernel' RETURN edition");
            return Mono.from((Publisher)result.records()).map(record -> record.get("edition").asString()).zipWhen(edition -> Mono.from((Publisher)result.consume()), (e, r) -> new ResultSummaryWithEdition((ResultSummary)r, (String)e));
        };
        return Flux.usingWhen((Publisher)Mono.fromSupplier(() -> this.driver.rxSession(Neo4jHealthIndicator.DEFAULT_SESSION_CONFIG)), s -> s.writeTransaction(txFunction), RxSession::close).single();
    }
}

