/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.test.autoconfigure;

import java.lang.reflect.Method;
import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jDriverProperties;
import org.neo4j.driver.springframework.boot.test.autoconfigure.Neo4jTestHarnessAutoConfiguration;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Neo4jDriverProperties.class})
class TestHarnessDriverConfiguration {
    TestHarnessDriverConfiguration() {
    }

    private static Driver createDriverFor(Neo4jDriverProperties driverProperties, ListableBeanFactory beanFactory, String embeddedServerClassName) {
        Neo4jTestHarnessAutoConfiguration.LOG.debug((Object)"Creating a driver instance connected against Neo4j test harness.");
        Class embeddedServerClass = ClassUtils.resolveClassName((String)embeddedServerClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
        Object embeddedServerInstance = beanFactory.getBean(embeddedServerClass);
        Method boltURI = ReflectionUtils.findMethod((Class)embeddedServerClass, (String)"boltURI");
        return GraphDatabase.driver((URI)((URI)ReflectionUtils.invokeMethod((Method)boltURI, (Object)embeddedServerInstance)), (AuthToken)AuthTokens.none(), (Config)driverProperties.asDriverConfig());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.neo4j.harness.Neo4j"})
    @ConditionalOnBean(type={"org.neo4j.harness.Neo4j"})
    static class Neo4jConfiguration {
        Neo4jConfiguration() {
        }

        @Bean
        Driver neo4jDriver(Neo4jDriverProperties driverProperties, ListableBeanFactory beanFactory) {
            return TestHarnessDriverConfiguration.createDriverFor(driverProperties, beanFactory, "org.neo4j.harness.Neo4j");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.neo4j.harness.ServerControls"})
    @ConditionalOnBean(type={"org.neo4j.harness.ServerControls"})
    static class ServerControlsConfiguration {
        ServerControlsConfiguration() {
        }

        @Bean
        Driver neo4jDriver(Neo4jDriverProperties driverProperties, ListableBeanFactory beanFactory) {
            return TestHarnessDriverConfiguration.createDriverFor(driverProperties, beanFactory, "org.neo4j.harness.ServerControls");
        }
    }
}

