/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.test.autoconfigure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Driver;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jDriverAutoConfiguration;
import org.neo4j.driver.springframework.boot.test.autoconfigure.TestHarnessDriverConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={Driver.class})
@AutoConfigureBefore(value={Neo4jDriverAutoConfiguration.class})
@Import(value={TestHarnessDriverConfiguration.class})
public class Neo4jTestHarnessAutoConfiguration {
    public static final String TEST_HARNESS_3X = "org.neo4j.harness.ServerControls";
    public static final String TEST_HARNESS_4X = "org.neo4j.harness.Neo4j";
    static final Log LOG = LogFactory.getLog(Neo4jTestHarnessAutoConfiguration.class);
    static final String BEAN_NAME = "neo4jTestHarness";

    static class Neo4jRegistrar
    implements ImportBeanDefinitionRegistrar {
        Neo4jRegistrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
            LOG.debug((Object)"Using Neo4j test harness 4.0");
            AbstractBeanDefinition factoryBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition((String)"org.neo4j.harness.Neo4jBuilders").setFactoryMethod("newInProcessBuilder").setInitMethodName("withDisabledServer").setScope("singleton").setRole(2).getBeanDefinition();
            String factoryBean = importBeanNameGenerator.generateBeanName((BeanDefinition)factoryBeanDefinition, registry);
            registry.registerBeanDefinition(factoryBean, (BeanDefinition)factoryBeanDefinition);
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition((String)Neo4jTestHarnessAutoConfiguration.TEST_HARNESS_4X).setFactoryMethodOnBean("build", factoryBean).setScope("singleton").setRole(2).getBeanDefinition();
            registry.registerBeanDefinition(Neo4jTestHarnessAutoConfiguration.BEAN_NAME, (BeanDefinition)beanDefinition);
        }
    }

    static class ServerControlsRegistrar
    implements ImportBeanDefinitionRegistrar {
        ServerControlsRegistrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
            LOG.debug((Object)"Using Neo4j test harness 3.5");
            AbstractBeanDefinition factoryBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition((String)"org.neo4j.harness.TestServerBuilders").setFactoryMethod("newInProcessBuilder").setScope("singleton").setRole(2).getBeanDefinition();
            String factoryBean = importBeanNameGenerator.generateBeanName((BeanDefinition)factoryBeanDefinition, registry);
            registry.registerBeanDefinition(factoryBean, (BeanDefinition)factoryBeanDefinition);
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition((String)Neo4jTestHarnessAutoConfiguration.TEST_HARNESS_3X).setFactoryMethodOnBean("newServer", factoryBean).setScope("singleton").setRole(2).getBeanDefinition();
            registry.registerBeanDefinition(Neo4jTestHarnessAutoConfiguration.BEAN_NAME, (BeanDefinition)beanDefinition);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.neo4j.harness.Neo4j"})
    @ConditionalOnMissingBean(type={"org.neo4j.harness.Neo4j"})
    @Import(value={Neo4jRegistrar.class})
    static class Neo4jConfiguration {
        Neo4jConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.neo4j.harness.ServerControls"})
    @ConditionalOnMissingBean(type={"org.neo4j.harness.ServerControls"})
    @Import(value={ServerControlsRegistrar.class})
    static class ServerControlsConfiguration {
        ServerControlsConfiguration() {
        }
    }
}

