/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import org.neo4j.driver.internal.net.pooling.BlockingPooledConnectionQueue;
import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.util.Function;

class PooledConnectionReleaseConsumer
implements Consumer<PooledConnection> {
    private final BlockingPooledConnectionQueue connections;
    private final Function<PooledConnection, Boolean> validConnection;

    PooledConnectionReleaseConsumer(BlockingPooledConnectionQueue connections, Function<PooledConnection, Boolean> validConnection) {
        this.connections = connections;
        this.validConnection = validConnection;
    }

    @Override
    public void accept(PooledConnection pooledConnection) {
        if (this.validConnection.apply(pooledConnection).booleanValue()) {
            this.connections.offer(pooledConnection);
        } else {
            pooledConnection.dispose();
        }
    }
}

