/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class AckFailureResponseHandler
implements ResponseHandler {
    private final InboundMessageDispatcher messageDispatcher;

    public AckFailureResponseHandler(InboundMessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.messageDispatcher.clearCurrentError();
    }

    @Override
    public void onFailure(Throwable error) {
        if (!this.messageDispatcher.isAckFailureMuted()) {
            throw new ClientException("Unable to acknowledge the previous error. Connection will be closed", error);
        }
        this.messageDispatcher.clearCurrentError();
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }
}

