/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.Logger;
import org.neo4j.driver.internal.shaded.reactor.util.Loggers;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;

final class MonoCompletionStage<T>
extends Mono<T>
implements Fuseable,
Scannable {
    static final Logger LOGGER = Loggers.getLogger(MonoCompletionStage.class);
    final CompletionStage<? extends T> future;

    MonoCompletionStage(CompletionStage<? extends T> future) {
        this.future = Objects.requireNonNull(future, "future");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoSubscriber sds = new Operators.MonoSubscriber(actual);
        actual.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        this.future.whenComplete((v, e) -> {
            if (sds.isCancelled()) {
                Context ctx = sds.currentContext();
                if (e == null || e instanceof CancellationException) {
                    Operators.onDiscard(v, ctx);
                } else {
                    Operators.onErrorDropped(e, ctx);
                    Operators.onDiscard(v, ctx);
                }
                return;
            }
            try {
                if (e != null) {
                    actual.onError((Throwable)e);
                } else if (v != null) {
                    sds.complete(v);
                } else {
                    actual.onComplete();
                }
            }
            catch (Throwable e1) {
                Operators.onErrorDropped(e1, actual.currentContext());
                throw Exceptions.bubble(e1);
            }
        });
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

