/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.cursor.AsyncStatementResultCursor;
import org.neo4j.driver.internal.cursor.AsyncStatementResultCursorImpl;
import org.neo4j.driver.internal.cursor.DisposableAsyncStatementResultCursor;
import org.neo4j.driver.internal.cursor.RxStatementResultCursor;
import org.neo4j.driver.internal.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;

public class AsyncStatementResultCursorOnlyFactory
implements StatementResultCursorFactory {
    protected final Connection connection;
    protected final Message runMessage;
    protected final RunResponseHandler runHandler;
    protected final PullAllResponseHandler pullAllHandler;
    private final boolean waitForRunResponse;

    public AsyncStatementResultCursorOnlyFactory(Connection connection, Message runMessage, RunResponseHandler runHandler, PullAllResponseHandler pullHandler, boolean waitForRunResponse) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(runMessage);
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(pullHandler);
        this.connection = connection;
        this.runMessage = runMessage;
        this.runHandler = runHandler;
        this.pullAllHandler = pullHandler;
        this.waitForRunResponse = waitForRunResponse;
    }

    @Override
    public CompletionStage<AsyncStatementResultCursor> asyncResult() {
        this.connection.write(this.runMessage, this.runHandler);
        this.pullAllHandler.prePopulateRecords();
        if (this.waitForRunResponse) {
            return this.runHandler.runFuture().thenApply(ignore -> new DisposableAsyncStatementResultCursor(new AsyncStatementResultCursorImpl(this.runHandler, this.pullAllHandler)));
        }
        return CompletableFuture.completedFuture(new DisposableAsyncStatementResultCursor(new AsyncStatementResultCursorImpl(this.runHandler, this.pullAllHandler)));
    }

    @Override
    public CompletionStage<RxStatementResultCursor> rxResult() {
        return Futures.failedFuture(new ClientException("Driver is connected to the database that does not support driver reactive API. In order to use the driver reactive API, please upgrade to neo4j 4.0.0 or later."));
    }
}

