/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.util.QueryKeys;

public class RunResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> runFuture;
    private final MetadataExtractor metadataExtractor;
    private long queryId = -1L;
    private QueryKeys queryKeys = QueryKeys.empty();
    private long resultAvailableAfter = -1L;
    private final Connection connection;
    private final UnmanagedTransaction tx;

    public RunResponseHandler(CompletableFuture<Void> runFuture, MetadataExtractor metadataExtractor, Connection connection, UnmanagedTransaction tx) {
        this.runFuture = runFuture;
        this.metadataExtractor = metadataExtractor;
        this.connection = connection;
        this.tx = tx;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.queryKeys = this.metadataExtractor.extractQueryKeys(metadata);
        this.resultAvailableAfter = this.metadataExtractor.extractResultAvailableAfter(metadata);
        this.queryId = this.metadataExtractor.extractQueryId(metadata);
        this.runFuture.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        if (this.tx != null) {
            this.tx.markTerminated(error);
        } else if (error instanceof AuthorizationExpiredException) {
            this.connection.terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
        }
        this.runFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    public QueryKeys queryKeys() {
        return this.queryKeys;
    }

    public long resultAvailableAfter() {
        return this.resultAvailableAfter;
    }

    public long queryId() {
        return this.queryId;
    }
}

