/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Session;
import org.neo4j.driver.internal.RevocationStrategy;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.handlers.pulln.FetchSizeUtil;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.net.ServerAddressResolver;
import org.neo4j.driver.util.Immutable;

@Immutable
public class Config {
    private static final Config EMPTY = Config.builder().build();
    private final Logging logging;
    private final boolean logLeakedSessions;
    private final int maxConnectionPoolSize;
    private final long idleTimeBeforeConnectionTest;
    private final long maxConnectionLifetimeMillis;
    private final long connectionAcquisitionTimeoutMillis;
    private final SecuritySettings securitySettings;
    private final int routingFailureLimit;
    private final long routingRetryDelayMillis;
    private final long fetchSize;
    private final long routingTablePurgeDelayMillis;
    private final int connectionTimeoutMillis;
    private final RetrySettings retrySettings;
    private final ServerAddressResolver resolver;
    private final boolean isMetricsEnabled;
    private final int eventLoopThreads;
    private final String userAgent;

    private Config(ConfigBuilder builder) {
        this.logging = builder.logging;
        this.logLeakedSessions = builder.logLeakedSessions;
        this.idleTimeBeforeConnectionTest = builder.idleTimeBeforeConnectionTest;
        this.maxConnectionLifetimeMillis = builder.maxConnectionLifetimeMillis;
        this.maxConnectionPoolSize = builder.maxConnectionPoolSize;
        this.connectionAcquisitionTimeoutMillis = builder.connectionAcquisitionTimeoutMillis;
        this.userAgent = builder.userAgent;
        this.securitySettings = builder.securitySettingsBuilder.build();
        this.routingFailureLimit = builder.routingFailureLimit;
        this.routingRetryDelayMillis = builder.routingRetryDelayMillis;
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.routingTablePurgeDelayMillis = builder.routingTablePurgeDelayMillis;
        this.retrySettings = builder.retrySettings;
        this.resolver = builder.resolver;
        this.fetchSize = builder.fetchSize;
        this.eventLoopThreads = builder.eventLoopThreads;
        this.isMetricsEnabled = builder.isMetricsEnabled;
    }

    public Logging logging() {
        return this.logging;
    }

    public boolean logLeakedSessions() {
        return this.logLeakedSessions;
    }

    public long idleTimeBeforeConnectionTest() {
        return this.idleTimeBeforeConnectionTest;
    }

    public long maxConnectionLifetimeMillis() {
        return this.maxConnectionLifetimeMillis;
    }

    public int connectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public int maxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public long connectionAcquisitionTimeoutMillis() {
        return this.connectionAcquisitionTimeoutMillis;
    }

    public boolean encrypted() {
        return this.securitySettings.encrypted();
    }

    public TrustStrategy trustStrategy() {
        return this.securitySettings.trustStrategy();
    }

    public ServerAddressResolver resolver() {
        return this.resolver;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public static Config defaultConfig() {
        return EMPTY;
    }

    SecuritySettings securitySettings() {
        return this.securitySettings;
    }

    RoutingSettings routingSettings() {
        return new RoutingSettings(this.routingFailureLimit, this.routingRetryDelayMillis, this.routingTablePurgeDelayMillis);
    }

    RetrySettings retrySettings() {
        return this.retrySettings;
    }

    public long fetchSize() {
        return this.fetchSize;
    }

    public int eventLoopThreads() {
        return this.eventLoopThreads;
    }

    public boolean isMetricsEnabled() {
        return this.isMetricsEnabled;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public static class TrustStrategy {
        private final Strategy strategy;
        private final File certFile;
        private boolean hostnameVerificationEnabled = true;
        private RevocationStrategy revocationStrategy = RevocationStrategy.NO_CHECKS;

        private TrustStrategy(Strategy strategy) {
            this(strategy, null);
        }

        private TrustStrategy(Strategy strategy, File certFile) {
            this.strategy = strategy;
            this.certFile = certFile;
        }

        public Strategy strategy() {
            return this.strategy;
        }

        public File certFile() {
            return this.certFile;
        }

        public boolean isHostnameVerificationEnabled() {
            return this.hostnameVerificationEnabled;
        }

        public TrustStrategy withHostnameVerification() {
            this.hostnameVerificationEnabled = true;
            return this;
        }

        public TrustStrategy withoutHostnameVerification() {
            this.hostnameVerificationEnabled = false;
            return this;
        }

        public static TrustStrategy trustCustomCertificateSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustSystemCertificates() {
            return new TrustStrategy(Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES);
        }

        public static TrustStrategy trustAllCertificates() {
            return new TrustStrategy(Strategy.TRUST_ALL_CERTIFICATES);
        }

        public RevocationStrategy revocationStrategy() {
            return this.revocationStrategy;
        }

        public TrustStrategy withoutCertificateRevocationChecks() {
            this.revocationStrategy = RevocationStrategy.NO_CHECKS;
            return this;
        }

        public TrustStrategy withVerifyIfPresentRevocationChecks() {
            this.revocationStrategy = RevocationStrategy.VERIFY_IF_PRESENT;
            return this;
        }

        public TrustStrategy withStrictRevocationChecks() {
            this.revocationStrategy = RevocationStrategy.STRICT;
            return this;
        }

        public static enum Strategy {
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }

    public static class ConfigBuilder {
        private Logging logging = DevNullLogging.DEV_NULL_LOGGING;
        private boolean logLeakedSessions;
        private int maxConnectionPoolSize = 100;
        private long idleTimeBeforeConnectionTest = -1L;
        private long maxConnectionLifetimeMillis = PoolSettings.DEFAULT_MAX_CONNECTION_LIFETIME;
        private long connectionAcquisitionTimeoutMillis = PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT;
        private String userAgent = String.format("neo4j-java/%s", ConfigBuilder.driverVersion());
        private final SecuritySettings.SecuritySettingsBuilder securitySettingsBuilder = new SecuritySettings.SecuritySettingsBuilder();
        private int routingFailureLimit = RoutingSettings.DEFAULT.maxRoutingFailures();
        private long routingRetryDelayMillis = RoutingSettings.DEFAULT.retryTimeoutDelay();
        private long routingTablePurgeDelayMillis = RoutingSettings.DEFAULT.routingTablePurgeDelayMs();
        private int connectionTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(30L);
        private RetrySettings retrySettings = RetrySettings.DEFAULT;
        private ServerAddressResolver resolver;
        private boolean isMetricsEnabled = false;
        private long fetchSize = 1000L;
        private int eventLoopThreads = 0;

        private ConfigBuilder() {
        }

        public ConfigBuilder withLogging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public ConfigBuilder withLeakedSessionsLogging() {
            this.logLeakedSessions = true;
            return this;
        }

        public ConfigBuilder withConnectionLivenessCheckTimeout(long value, TimeUnit unit) {
            this.idleTimeBeforeConnectionTest = unit.toMillis(value);
            return this;
        }

        public ConfigBuilder withMaxConnectionLifetime(long value, TimeUnit unit) {
            this.maxConnectionLifetimeMillis = unit.toMillis(value);
            return this;
        }

        public ConfigBuilder withMaxConnectionPoolSize(int value) {
            if (value == 0) {
                throw new IllegalArgumentException("Zero value is not supported");
            }
            this.maxConnectionPoolSize = value < 0 ? Integer.MAX_VALUE : value;
            return this;
        }

        public ConfigBuilder withConnectionAcquisitionTimeout(long value, TimeUnit unit) {
            long valueInMillis = unit.toMillis(value);
            this.connectionAcquisitionTimeoutMillis = value >= 0L ? valueInMillis : -1L;
            return this;
        }

        public ConfigBuilder withEncryption() {
            this.securitySettingsBuilder.withEncryption();
            return this;
        }

        public ConfigBuilder withoutEncryption() {
            this.securitySettingsBuilder.withoutEncryption();
            return this;
        }

        public ConfigBuilder withTrustStrategy(TrustStrategy trustStrategy) {
            this.securitySettingsBuilder.withTrustStrategy(trustStrategy);
            return this;
        }

        @Deprecated
        public ConfigBuilder withRoutingFailureLimit(int routingFailureLimit) {
            if (routingFailureLimit < 1) {
                throw new IllegalArgumentException("The failure limit may not be smaller than 1, but was: " + routingFailureLimit);
            }
            this.routingFailureLimit = routingFailureLimit;
            return this;
        }

        @Deprecated
        public ConfigBuilder withRoutingRetryDelay(long delay, TimeUnit unit) {
            long routingRetryDelayMillis = unit.toMillis(delay);
            if (routingRetryDelayMillis < 0L) {
                throw new IllegalArgumentException(String.format("The retry delay may not be smaller than 0, but was %d %s.", new Object[]{delay, unit}));
            }
            this.routingRetryDelayMillis = routingRetryDelayMillis;
            return this;
        }

        public ConfigBuilder withRoutingTablePurgeDelay(long delay, TimeUnit unit) {
            long routingTablePurgeDelayMillis = unit.toMillis(delay);
            if (routingTablePurgeDelayMillis < 0L) {
                throw new IllegalArgumentException(String.format("The routing table purge delay may not be smaller than 0, but was %d %s.", new Object[]{delay, unit}));
            }
            this.routingTablePurgeDelayMillis = routingTablePurgeDelayMillis;
            return this;
        }

        public ConfigBuilder withFetchSize(long size) {
            this.fetchSize = FetchSizeUtil.assertValidFetchSize(size);
            return this;
        }

        public ConfigBuilder withConnectionTimeout(long value, TimeUnit unit) {
            long connectionTimeoutMillis = unit.toMillis(value);
            if (connectionTimeoutMillis < 0L) {
                throw new IllegalArgumentException(String.format("The connection timeout may not be smaller than 0, but was %d %s.", new Object[]{value, unit}));
            }
            int connectionTimeoutMillisInt = (int)connectionTimeoutMillis;
            if ((long)connectionTimeoutMillisInt != connectionTimeoutMillis) {
                throw new IllegalArgumentException(String.format("The connection timeout must represent int value when converted to milliseconds %d.", connectionTimeoutMillis));
            }
            this.connectionTimeoutMillis = connectionTimeoutMillisInt;
            return this;
        }

        public ConfigBuilder withMaxTransactionRetryTime(long value, TimeUnit unit) {
            long maxRetryTimeMs = unit.toMillis(value);
            if (maxRetryTimeMs < 0L) {
                throw new IllegalArgumentException(String.format("The max retry time may not be smaller than 0, but was %d %s.", new Object[]{value, unit}));
            }
            this.retrySettings = new RetrySettings(maxRetryTimeMs);
            return this;
        }

        public ConfigBuilder withResolver(ServerAddressResolver resolver) {
            this.resolver = Objects.requireNonNull(resolver, "resolver");
            return this;
        }

        public ConfigBuilder withDriverMetrics() {
            this.isMetricsEnabled = true;
            return this;
        }

        public ConfigBuilder withoutDriverMetrics() {
            this.isMetricsEnabled = false;
            return this;
        }

        public ConfigBuilder withEventLoopThreads(int size) {
            if (size < 1) {
                throw new IllegalArgumentException(String.format("The event loop thread may not be smaller than 1, but was %d.", size));
            }
            this.eventLoopThreads = size;
            return this;
        }

        public ConfigBuilder withUserAgent(String userAgent) {
            if (userAgent == null || userAgent.isEmpty()) {
                throw new IllegalArgumentException("The user_agent string must not be empty");
            }
            this.userAgent = userAgent;
            return this;
        }

        private static String driverVersion() {
            Package pkg = Session.class.getPackage();
            if (pkg != null && pkg.getImplementationVersion() != null) {
                return pkg.getImplementationVersion();
            }
            return "dev";
        }

        public Config build() {
            return new Config(this);
        }
    }
}

