/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.BookmarksSupplier;
import org.neo4j.driver.internal.util.LockUtil;

public final class Neo4jBookmarkManager
implements BookmarkManager {
    private static final long serialVersionUID = 6615186840717102303L;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Map<String, Set<Bookmark>> databaseToBookmarks = new HashMap<String, Set<Bookmark>>();
    private final BiConsumer<String, Set<Bookmark>> updateListener;
    private final BookmarksSupplier bookmarksSupplier;

    public Neo4jBookmarkManager(Map<String, Set<Bookmark>> initialBookmarks, BiConsumer<String, Set<Bookmark>> updateListener, BookmarksSupplier bookmarksSupplier) {
        Objects.requireNonNull(initialBookmarks, "initialBookmarks must not be null");
        this.databaseToBookmarks.putAll(initialBookmarks);
        this.updateListener = updateListener;
        this.bookmarksSupplier = bookmarksSupplier;
    }

    @Override
    public void updateBookmarks(String database, Set<Bookmark> previousBookmarks, Set<Bookmark> newBookmarks) {
        Set immutableBookmarks = LockUtil.executeWithLock(this.rwLock.writeLock(), () -> this.databaseToBookmarks.compute(database, (ignored, bookmarks) -> {
            HashSet updatedBookmarks = new HashSet();
            if (bookmarks != null) {
                bookmarks.stream().filter(bookmark -> !previousBookmarks.contains(bookmark)).forEach(updatedBookmarks::add);
            }
            updatedBookmarks.addAll(newBookmarks);
            return Collections.unmodifiableSet(updatedBookmarks);
        }));
        if (this.updateListener != null) {
            this.updateListener.accept(database, immutableBookmarks);
        }
    }

    @Override
    public Set<Bookmark> getBookmarks(String database) {
        Set immutableBookmarks = LockUtil.executeWithLock(this.rwLock.readLock(), () -> this.databaseToBookmarks.getOrDefault(database, Collections.emptySet()));
        if (this.bookmarksSupplier != null) {
            HashSet<Bookmark> bookmarks = new HashSet<Bookmark>(immutableBookmarks);
            bookmarks.addAll(this.bookmarksSupplier.getBookmarks(database));
            immutableBookmarks = Collections.unmodifiableSet(bookmarks);
        }
        return immutableBookmarks;
    }

    @Override
    public Set<Bookmark> getAllBookmarks() {
        Set<Bookmark> immutableBookmarks = LockUtil.executeWithLock(this.rwLock.readLock(), () -> this.databaseToBookmarks.values().stream().flatMap(Collection::stream)).collect(Collectors.toUnmodifiableSet());
        if (this.bookmarksSupplier != null) {
            HashSet<Bookmark> bookmarks = new HashSet<Bookmark>(immutableBookmarks);
            bookmarks.addAll(this.bookmarksSupplier.getAllBookmarks());
            immutableBookmarks = Collections.unmodifiableSet(bookmarks);
        }
        return immutableBookmarks;
    }

    @Override
    public void forget(Set<String> databases) {
        LockUtil.executeWithLock(this.rwLock.writeLock(), () -> databases.forEach(this.databaseToBookmarks::remove));
    }
}

