/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.AsyncResultCursorImpl;
import org.neo4j.driver.internal.cursor.DisposableAsyncResultCursor;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;

public class AsyncResultCursorOnlyFactory
implements ResultCursorFactory {
    protected final Connection connection;
    protected final Message runMessage;
    protected final RunResponseHandler runHandler;
    private final CompletableFuture<Void> runFuture;
    protected final PullAllResponseHandler pullAllHandler;

    public AsyncResultCursorOnlyFactory(Connection connection, Message runMessage, RunResponseHandler runHandler, CompletableFuture<Void> runFuture, PullAllResponseHandler pullHandler) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(runMessage);
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(runFuture);
        Objects.requireNonNull(pullHandler);
        this.connection = connection;
        this.runMessage = runMessage;
        this.runHandler = runHandler;
        this.runFuture = runFuture;
        this.pullAllHandler = pullHandler;
    }

    @Override
    public CompletionStage<AsyncResultCursor> asyncResult() {
        this.connection.write(this.runMessage, this.runHandler);
        this.pullAllHandler.prePopulateRecords();
        return this.runFuture.handle((ignored, error) -> new DisposableAsyncResultCursor(new AsyncResultCursorImpl((Throwable)error, this.runHandler, this.pullAllHandler)));
    }

    @Override
    public CompletionStage<RxResultCursor> rxResult() {
        return Futures.failedFuture(new ClientException("Driver is connected to the database that does not support driver reactive API. In order to use the driver reactive API, please upgrade to neo4j 4.0.0 or later."));
    }
}

