/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.spi.ResponseHandler;

public class BeginTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> beginTxFuture;

    public BeginTxResponseHandler(CompletableFuture<Void> beginTxFuture) {
        this.beginTxFuture = Objects.requireNonNull(beginTxFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.beginTxFuture.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.beginTxFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction begin is not expected to receive records: " + Arrays.toString(fields));
    }
}

