/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.AuthData;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionState;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.bolt.api.TransactionType;

public class TerminationAwareBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final TerminationAwareStateLockingExecutor executor;

    public TerminationAwareBoltConnection(BoltConnection delegate, TerminationAwareStateLockingExecutor executor) {
        this.delegate = Objects.requireNonNull(delegate);
        this.executor = Objects.requireNonNull(executor);
    }

    public CompletionStage<BoltConnection> clearAndReset() {
        final CompletableFuture<BoltConnection> future = new CompletableFuture<BoltConnection>();
        final TerminationAwareBoltConnection thisVal = this;
        this.delegate.clear().thenCompose(BoltConnection::reset).thenCompose(connection -> connection.flush(new ResponseHandler(){

            @Override
            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                future.complete(thisVal);
            }
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    @Override
    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    @Override
    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    @Override
    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    @Override
    public CompletionStage<AuthData> authData() {
        return this.delegate.authData();
    }

    @Override
    public BoltConnectionState state() {
        return this.delegate.state();
    }

    @Override
    public CompletionStage<Void> close() {
        return this.delegate.close();
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason);
    }

    @Override
    public CompletionStage<Void> flush(ResponseHandler handler) {
        return this.executor.execute(causeOfTermination -> {
            if (causeOfTermination == null) {
                return this.delegate.flush(handler);
            }
            return CompletableFuture.failedStage(causeOfTermination);
        });
    }

    @Override
    public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.delegate.telemetry(telemetryApi);
    }

    @Override
    public CompletionStage<BoltConnection> clear() {
        return this.delegate.clear();
    }

    @Override
    public CompletionStage<BoltConnection> logon(Map<String, Value> authMap) {
        return this.delegate.logon(authMap);
    }

    @Override
    public CompletionStage<BoltConnection> logoff() {
        return this.delegate.logoff();
    }

    @Override
    public CompletionStage<BoltConnection> reset() {
        return this.delegate.reset();
    }

    @Override
    public CompletionStage<BoltConnection> rollback() {
        return this.delegate.rollback();
    }

    @Override
    public CompletionStage<BoltConnection> commit() {
        return this.delegate.commit();
    }

    @Override
    public CompletionStage<BoltConnection> discard(long qid, long number) {
        return this.delegate.discard(qid, number);
    }

    @Override
    public CompletionStage<BoltConnection> pull(long qid, long request) {
        return this.delegate.pull(qid, request);
    }

    @Override
    public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
        return this.delegate.run(query, parameters);
    }

    @Override
    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.delegate.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, parameters, txTimeout, txMetadata, notificationConfig);
    }

    @Override
    public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.delegate.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, txType, notificationConfig);
    }

    @Override
    public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.delegate.route(databaseName, impersonatedUser, bookmarks);
    }
}

