/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging.v43;

import java.time.Clock;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.ClusterComposition;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.RouteMessageResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltProtocol;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageFormat;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.RouteMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v43.MessageFormatV43;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;
import org.neo4j.driver.types.MapAccessor;

public class BoltProtocolV43
extends BoltProtocolV42 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(4, 3);
    public static final BoltProtocol INSTANCE = new BoltProtocolV43();

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV43();
    }

    @Override
    public CompletionStage<Void> route(Connection connection, Map<String, Value> routingContext, Set<String> bookmarks, String databaseName, String impersonatedUser, MessageHandler<RouteSummary> handler, Clock clock, LoggingProvider logging) {
        RouteMessage routeMessage = new RouteMessage(routingContext, bookmarks, databaseName, impersonatedUser);
        CompletableFuture<Map<String, Value>> routeFuture = new CompletableFuture<Map<String, Value>>();
        ((CompletableFuture)routeFuture.thenApply(map -> {
            long ttl = ((Value)map.get("ttl")).asLong();
            long expirationTimestamp = clock.millis() + ttl * 1000L;
            if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
                expirationTimestamp = Long.MAX_VALUE;
            }
            LinkedHashSet<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
            for (Map serversMap : ((Value)map.get("servers")).asList(MapAccessor::asMap)) {
                String role = Values.value(serversMap.get("role")).asString();
                for (Object server : Values.value(serversMap.get("addresses")).asList()) {
                    BoltServerAddress address = new BoltServerAddress(Values.value(server).asString());
                    switch (role) {
                        case "WRITE": {
                            writers.add(address);
                            break;
                        }
                        case "READ": {
                            readers.add(address);
                            break;
                        }
                        case "ROUTE": {
                            routers.add(address);
                        }
                    }
                }
            }
            Value db = (Value)map.get("db");
            String name = db != null ? (String)db.computeOrDefault(Value::asString, null) : null;
            ClusterComposition clusterComposition = new ClusterComposition(expirationTimestamp, readers, writers, routers, name);
            return new RouteSummaryImpl(clusterComposition);
        })).whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RouteSummary)summary);
            }
        });
        RouteMessageResponseHandler routeHandler = new RouteMessageResponseHandler(routeFuture);
        return connection.write(routeMessage, routeHandler);
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    @Override
    protected boolean includeDateTimeUtcPatchInHello() {
        return true;
    }

    private record RouteSummaryImpl(ClusterComposition clusterComposition) implements RouteSummary
    {
    }
}

