/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.adaptedbolt.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.summary.BeginSummary;
import org.neo4j.driver.internal.bolt.api.summary.CommitSummary;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogoffSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogonSummary;
import org.neo4j.driver.internal.bolt.api.summary.ResetSummary;
import org.neo4j.driver.internal.bolt.api.summary.RollbackSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.api.summary.TelemetrySummary;
import org.neo4j.driver.internal.value.BoltValue;
import org.neo4j.driver.internal.value.BoltValueFactory;

final class AdaptingDriverResponseHandler
implements ResponseHandler {
    private final DriverResponseHandler delegate;
    private final ErrorMapper errorMapper;
    private final BoltValueFactory boltValueFactory;

    AdaptingDriverResponseHandler(DriverResponseHandler delegate, ErrorMapper errorMapper, BoltValueFactory boltValueFactory) {
        this.delegate = Objects.requireNonNull(delegate);
        this.errorMapper = Objects.requireNonNull(errorMapper);
        this.boltValueFactory = Objects.requireNonNull(boltValueFactory);
    }

    @Override
    public void onError(Throwable throwable) {
        this.delegate.onError(this.errorMapper.map(throwable));
    }

    @Override
    public void onBeginSummary(BeginSummary summary) {
        this.delegate.onBeginSummary(summary);
    }

    @Override
    public void onRunSummary(RunSummary summary) {
        this.delegate.onRunSummary(summary);
    }

    @Override
    public void onRecord(org.neo4j.driver.internal.bolt.api.values.Value[] fields) {
        Value[] mappedFields = (Value[])Arrays.stream(fields).map(field -> ((BoltValue)field).asDriverValue()).toArray(Value[]::new);
        this.delegate.onRecord(mappedFields);
    }

    @Override
    public void onPullSummary(final org.neo4j.driver.internal.bolt.api.summary.PullSummary summary) {
        this.delegate.onPullSummary(new PullSummary(){

            @Override
            public boolean hasMore() {
                return summary.hasMore();
            }

            @Override
            public Map<String, Value> metadata() {
                return AdaptingDriverResponseHandler.this.boltValueFactory.toDriverMap(summary.metadata());
            }
        });
    }

    @Override
    public void onDiscardSummary(DiscardSummary summary) {
        this.delegate.onDiscardSummary(() -> this.boltValueFactory.toDriverMap(summary.metadata()));
    }

    @Override
    public void onCommitSummary(CommitSummary summary) {
        this.delegate.onCommitSummary(summary);
    }

    @Override
    public void onRollbackSummary(RollbackSummary summary) {
        this.delegate.onRollbackSummary(summary);
    }

    @Override
    public void onResetSummary(ResetSummary summary) {
        this.delegate.onResetSummary(summary);
    }

    @Override
    public void onRouteSummary(RouteSummary summary) {
        this.delegate.onRouteSummary(summary);
    }

    @Override
    public void onLogoffSummary(LogoffSummary summary) {
        this.delegate.onLogoffSummary(summary);
    }

    @Override
    public void onLogonSummary(LogonSummary summary) {
        this.delegate.onLogonSummary(summary);
    }

    @Override
    public void onTelemetrySummary(TelemetrySummary summary) {
        this.delegate.onTelemetrySummary(summary);
    }

    @Override
    public void onIgnored() {
        this.delegate.onIgnored();
    }

    @Override
    public void onComplete() {
        this.delegate.onComplete();
    }
}

