/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.SecurityRetryableException;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.async.DelegatingBoltConnection;
import org.neo4j.driver.internal.async.ErrorMappingResponseHandler;
import org.neo4j.driver.internal.bolt.api.AuthInfo;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.value.BoltValueFactory;

final class BoltConnectionWithAuthTokenManager
extends DelegatingBoltConnection {
    private final AuthTokenManager authTokenManager;

    public BoltConnectionWithAuthTokenManager(DriverBoltConnection delegate, AuthTokenManager authTokenManager) {
        super(delegate);
        this.authTokenManager = Objects.requireNonNull(authTokenManager);
    }

    @Override
    public CompletionStage<Void> flush(DriverResponseHandler handler) {
        return this.delegate.flush(new ErrorMappingResponseHandler(handler, this::mapSecurityError));
    }

    private Throwable mapSecurityError(Throwable throwable) {
        if (throwable instanceof SecurityException) {
            SecurityException securityException = (SecurityException)throwable;
            AuthInfo authInfo = this.delegate.authData().toCompletableFuture().getNow(null);
            if (authInfo != null && this.authTokenManager.handleSecurityException(new InternalAuthToken(BoltValueFactory.getInstance().toDriverMap(authInfo.authToken().asMap())), securityException)) {
                throwable = new SecurityRetryableException(securityException);
            }
        }
        return throwable;
    }
}

