/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.util.Futures;

public class ResultCursorsHolder {
    private final List<CompletionStage<? extends FailableCursor>> cursorStages = new ArrayList<CompletionStage<? extends FailableCursor>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(CompletionStage<? extends FailableCursor> cursorStage) {
        Objects.requireNonNull(cursorStage);
        ResultCursorsHolder resultCursorsHolder = this;
        synchronized (resultCursorsHolder) {
            this.cursorStages.add(cursorStage);
        }
        cursorStage.thenCompose(FailableCursor::consumed).whenComplete((ignored, throwable) -> {
            throwable = Futures.completionExceptionCause(throwable);
            ResultCursorsHolder resultCursorsHolder = this;
            synchronized (resultCursorsHolder) {
                if (throwable == null) {
                    this.cursorStages.remove(cursorStage);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletionStage<Throwable> retrieveNotConsumedError() {
        List<CompletionStage<? extends FailableCursor>> cursorStages;
        ResultCursorsHolder resultCursorsHolder = this;
        synchronized (resultCursorsHolder) {
            cursorStages = List.copyOf(this.cursorStages);
        }
        CompletableFuture[] failures = ResultCursorsHolder.retrieveAllFailures(cursorStages);
        return CompletableFuture.allOf(failures).thenApply(ignore -> ResultCursorsHolder.findFirstFailure(failures));
    }

    private static CompletableFuture<Throwable>[] retrieveAllFailures(List<CompletionStage<? extends FailableCursor>> cursorStages) {
        return (CompletableFuture[])cursorStages.stream().map(ResultCursorsHolder::retrieveFailure).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
    }

    private static Throwable findFirstFailure(CompletableFuture<Throwable>[] completedFailureFutures) {
        return Arrays.stream(completedFailureFutures).map(failureFuture -> failureFuture.getNow(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static CompletionStage<Throwable> retrieveFailure(CompletionStage<? extends FailableCursor> cursorStage) {
        return cursorStage.exceptionally(cursor -> null).thenCompose(cursor -> cursor == null ? Futures.completedWithNull() : cursor.discardAllFailureAsync());
    }
}

