/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl.impl.util;

import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public class LockUtil {
    public static void executeWithLock(Lock lock, Runnable runnable) {
        LockUtil.lock(lock);
        try {
            runnable.run();
        }
        finally {
            LockUtil.unlock(lock);
        }
    }

    public static <T> T executeWithLock(Lock lock, Supplier<T> supplier) {
        LockUtil.lock(lock);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            LockUtil.unlock(lock);
        }
    }

    private static void lock(Lock lock) {
        lock.lock();
    }

    private static void unlock(Lock lock) {
        lock.unlock();
    }
}

