/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.net.URI;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.observation.BoltExchangeObservation;
import org.neo4j.bolt.connection.observation.HttpExchangeObservation;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.bolt.connection.pooled.observation.PoolObservationProvider;
import org.neo4j.driver.internal.adaptedbolt.BoltExchangeObservationImpl;
import org.neo4j.driver.internal.adaptedbolt.BoltObservation;
import org.neo4j.driver.internal.adaptedbolt.HttpExchangeObservationImpl;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;

public final class BoltObservationProvider
implements PoolObservationProvider {
    private final DriverObservationProvider delegate;

    public BoltObservationProvider(DriverObservationProvider delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public org.neo4j.bolt.connection.observation.Observation connectionPoolCreate(String id, URI uri, int maxSize) {
        return new BoltObservation(this.delegate.connectionPoolCreate(id, uri, maxSize).start());
    }

    public org.neo4j.bolt.connection.observation.Observation connectionPoolClose(String id, URI uri) {
        return new BoltObservation(this.delegate.connectionPoolClose(id, uri).start());
    }

    public org.neo4j.bolt.connection.observation.Observation pooledConnectionCreate(String id, URI uri) {
        return new BoltObservation(this.delegate.pooledConnectionCreate(id, uri).start());
    }

    public org.neo4j.bolt.connection.observation.Observation pooledConnectionClose(String id, URI uri) {
        return new BoltObservation(this.delegate.pooledConnectionClose(id, uri).start());
    }

    public org.neo4j.bolt.connection.observation.Observation pooledConnectionAcquire(String id, URI uri) {
        return new BoltObservation(this.delegate.pooledConnectionAcquire(id, uri).start());
    }

    public org.neo4j.bolt.connection.observation.Observation pooledConnectionInUse(ImmutableObservation parentObsevation, String id, URI uri) {
        return this.supplyInScope(parentObsevation, () -> new BoltObservation(this.delegate.pooledConnectionInUse(id, uri).start()));
    }

    public BoltExchangeObservation boltExchange(ImmutableObservation parentObsevation, String host, int port, BoltProtocolVersion boltVersion, BiConsumer<String, String> setter) {
        return this.supplyInScope(parentObsevation, () -> new BoltExchangeObservationImpl(this.delegate.boltExchange(host, port, boltVersion, setter).start()));
    }

    public HttpExchangeObservation httpExchange(ImmutableObservation parentObsevation, URI uri, String method, String uriTemplate, BiConsumer<String, String> setter) {
        return this.supplyInScope(parentObsevation, () -> new HttpExchangeObservationImpl(this.delegate.httpExchange(uri, method, uriTemplate, setter).start()));
    }

    public org.neo4j.bolt.connection.observation.Observation scopedObservation() {
        Observation observation = this.delegate.scopedObservation();
        return observation != null ? new BoltObservation(observation) : null;
    }

    public <T> T supplyInScope(ImmutableObservation observation, Supplier<T> supplier) {
        if (observation instanceof BoltObservation) {
            BoltObservation boltObservation = (BoltObservation)observation;
            org.neo4j.bolt.connection.observation.Observation scopedObservation = this.scopedObservation();
            if (observation.equals((Object)scopedObservation)) {
                return supplier.get();
            }
            try (Observation.Scope scope = boltObservation.delegate().openScope();){
                T t = supplier.get();
                return t;
            }
        }
        return supplier.get();
    }
}

