/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import org.neo4j.gds.Algorithm;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.logging.Log;

public interface AlgorithmFactory<G, ALGO extends Algorithm<?>, CONFIG extends AlgoBaseConfig> {
    default public ALGO build(G graphOrGraphStore, CONFIG configuration, Log log, TaskRegistryFactory taskRegistryFactory) {
        return this.build(graphOrGraphStore, configuration, log, taskRegistryFactory, (UserLogRegistryFactory)EmptyUserLogRegistryFactory.INSTANCE);
    }

    default public ALGO build(G graphOrGraphStore, CONFIG configuration, Log log, TaskRegistryFactory taskRegistryFactory, UserLogRegistryFactory userLogRegistryFactory) {
        Task progressTask = this.progressTask(graphOrGraphStore, configuration);
        TaskProgressTracker progressTracker = new TaskProgressTracker(progressTask, log, configuration.concurrency(), taskRegistryFactory, userLogRegistryFactory);
        return this.build(graphOrGraphStore, configuration, (ProgressTracker)progressTracker);
    }

    public ALGO build(G var1, CONFIG var2, ProgressTracker var3);

    default public Task progressTask(G graphOrGraphStore, CONFIG config) {
        return Tasks.leaf((String)this.taskName());
    }

    public String taskName();

    default public MemoryEstimation memoryEstimation(CONFIG configuration) {
        throw new MemoryEstimationNotImplementedException();
    }

    default public GraphDimensions estimatedGraphDimensionTransformer(GraphDimensions graphDimensions, CONFIG config) {
        return graphDimensions;
    }

    public ALGO accept(Visitor<ALGO, CONFIG> var1);

    public static interface Visitor<ALGO extends Algorithm<?>, CONFIG extends AlgoBaseConfig> {
        public ALGO graph(GraphAlgorithmFactory<ALGO, CONFIG> var1);

        public ALGO graphStore(GraphStoreAlgorithmFactory<ALGO, CONFIG> var1);
    }
}

