/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.result;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.LongToDoubleFunction;
import org.HdrHistogram.DoubleHistogram;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;

public final class CentralityStatistics {
    public static DoubleHistogram histogram(long nodeCount, LongToDoubleFunction centralityFunction, ExecutorService executorService, int concurrency) {
        DoubleHistogram histogram;
        if (concurrency == 1) {
            histogram = new DoubleHistogram(5);
            for (long id = 0L; id < nodeCount; ++id) {
                histogram.recordValue(centralityFunction.applyAsDouble(id));
            }
        } else {
            List tasks = PartitionUtils.rangePartition((int)concurrency, (long)nodeCount, partition -> new RecordTask((Partition)partition, centralityFunction), Optional.empty());
            ParallelUtil.run((Collection)tasks, (ExecutorService)executorService);
            histogram = new DoubleHistogram(5);
            for (RecordTask task : tasks) {
                histogram.add(task.histogram);
            }
        }
        return histogram;
    }

    private CentralityStatistics() {
    }

    private static class RecordTask
    implements Runnable {
        private final DoubleHistogram histogram;
        private final Partition partition;
        private final LongToDoubleFunction centralityFunction;

        RecordTask(Partition partition, LongToDoubleFunction centralityFunction) {
            this.partition = partition;
            this.centralityFunction = centralityFunction;
            this.histogram = new DoubleHistogram(5);
        }

        @Override
        public void run() {
            this.partition.consume(id -> this.histogram.recordValue(this.centralityFunction.applyAsDouble(id)));
        }
    }
}

