/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.result;

import com.carrotsearch.hppc.LongLongHashMap;
import com.carrotsearch.hppc.LongLongMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.LongUnaryOperator;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.collections.HugeSparseLongArray;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.LazyBatchCollection;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.result.ImmutableCommunityCountAndHistogram;

public final class CommunityStatistics {
    private static final long EMPTY_COMMUNITY = 0L;

    public static HugeSparseLongArray communitySizes(long nodeCount, LongUnaryOperator communityFunction, ExecutorService executorService, int concurrency) {
        HugeSparseLongArray.Builder componentSizeBuilder = HugeSparseLongArray.builder((long)0L);
        if (concurrency == 1) {
            for (long nodeId = 0L; nodeId < nodeCount; ++nodeId) {
                componentSizeBuilder.addTo(communityFunction.applyAsLong(nodeId), 1L);
            }
        } else {
            long batchSize = ParallelUtil.adjustedBatchSize((long)nodeCount, (int)concurrency, (long)10000L, (long)100000L);
            Collection tasks = LazyBatchCollection.of((long)nodeCount, (long)batchSize, (start, length) -> new AddTask(componentSizeBuilder, communityFunction, start, length));
            ParallelUtil.run((Collection)tasks, (ExecutorService)executorService);
        }
        return componentSizeBuilder.build();
    }

    public static long communityCount(long nodeCount, LongUnaryOperator communityFunction, ExecutorService executorService, int concurrency) {
        HugeSparseLongArray communitySizes = CommunityStatistics.communitySizes(nodeCount, communityFunction, executorService, concurrency);
        return CommunityStatistics.communityCount(communitySizes, executorService, concurrency);
    }

    public static long communityCount(HugeSparseLongArray communitySizes, ExecutorService executorService, int concurrency) {
        long capacity = communitySizes.capacity();
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)capacity, partition -> new CountTask(communitySizes, (Partition)partition), Optional.empty());
        ParallelUtil.run((Collection)tasks, (ExecutorService)executorService);
        long communityCount = 0L;
        for (CountTask task : tasks) {
            communityCount += task.count();
        }
        return communityCount;
    }

    public static CommunityCountAndHistogram communityCountAndHistogram(long nodeCount, LongUnaryOperator communityFunction, ExecutorService executorService, int concurrency) {
        HugeSparseLongArray communitySizes = CommunityStatistics.communitySizes(nodeCount, communityFunction, executorService, concurrency);
        return CommunityStatistics.communityCountAndHistogram(communitySizes, executorService, concurrency);
    }

    public static CommunityCountAndHistogram communityCountAndHistogram(HugeSparseLongArray communitySizes, ExecutorService executorService, int concurrency) {
        Histogram histogram;
        long communityCount = 0L;
        if (concurrency == 1) {
            histogram = new Histogram(5);
            long capacity = communitySizes.capacity();
            for (long communityId = 0L; communityId < capacity; ++communityId) {
                long communitySize = communitySizes.get(communityId);
                if (communitySize == 0L) continue;
                ++communityCount;
                histogram.recordValue(communitySize);
            }
        } else {
            long capacity = communitySizes.capacity();
            List tasks = PartitionUtils.rangePartition((int)concurrency, (long)capacity, partition -> new CountAndRecordTask(communitySizes, (Partition)partition), Optional.empty());
            ParallelUtil.run((Collection)tasks, (ExecutorService)executorService);
            long highestTrackableValue = 2L;
            for (CountAndRecordTask task : tasks) {
                communityCount += task.count;
                if (task.histogram.getMaxValue() <= highestTrackableValue) continue;
                highestTrackableValue = task.histogram.getMaxValue();
            }
            histogram = new Histogram(highestTrackableValue, 5);
            for (CountAndRecordTask task : tasks) {
                histogram.add((AbstractHistogram)task.histogram);
            }
        }
        return ImmutableCommunityCountAndHistogram.builder().componentCount(communityCount).histogram(histogram).build();
    }

    private CommunityStatistics() {
    }

    private static class CountAndRecordTask
    implements Runnable {
        private final HugeSparseLongArray communitySizes;
        private final Partition partition;
        private final Histogram histogram;
        private long count;

        CountAndRecordTask(HugeSparseLongArray communitySizes, Partition partition) {
            this.communitySizes = communitySizes;
            this.partition = partition;
            this.histogram = new Histogram(5);
        }

        @Override
        public void run() {
            this.partition.consume(id -> {
                long communitySize = this.communitySizes.get(id);
                if (communitySize != 0L) {
                    ++this.count;
                    this.histogram.recordValue(communitySize);
                }
            });
        }
    }

    private static class CountTask
    implements Runnable {
        private final HugeSparseLongArray communitySizes;
        private final Partition partition;
        private long count;

        CountTask(HugeSparseLongArray communitySizes, Partition partition) {
            this.communitySizes = communitySizes;
            this.partition = partition;
        }

        @Override
        public void run() {
            this.partition.consume(id -> {
                if (this.communitySizes.get(id) != 0L) {
                    ++this.count;
                }
            });
        }

        public long count() {
            return this.count;
        }
    }

    private static class AddTask
    implements Runnable {
        private final HugeSparseLongArray.Builder builder;
        private final LongUnaryOperator communityFunction;
        private final long startId;
        private final long length;
        private final LongLongMap buffer;

        AddTask(HugeSparseLongArray.Builder builder, LongUnaryOperator communityFunction, long startId, long length) {
            this.builder = builder;
            this.communityFunction = communityFunction;
            this.startId = startId;
            this.length = length;
            this.buffer = new LongLongHashMap((int)length);
        }

        @Override
        public void run() {
            long endId = this.startId + this.length;
            for (long id = this.startId; id < endId; ++id) {
                this.buffer.addTo(this.communityFunction.applyAsLong(id), 1L);
            }
            this.buffer.forEach((arg_0, arg_1) -> ((HugeSparseLongArray.Builder)this.builder).addTo(arg_0, arg_1));
        }
    }

    @ValueClass
    public static interface CommunityCountAndHistogram {
        public long componentCount();

        public Histogram histogram();
    }
}

