/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.result;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.HdrHistogram.Histogram;
import org.immutables.value.Generated;
import org.neo4j.gds.result.CommunityStatistics;

@ParametersAreNonnullByDefault
@Generated(from="CommunityStatistics.CommunityCountAndHistogram", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCommunityCountAndHistogram
implements CommunityStatistics.CommunityCountAndHistogram {
    private final long componentCount;
    private final Histogram histogram;

    private ImmutableCommunityCountAndHistogram(long componentCount, Histogram histogram) {
        this.componentCount = componentCount;
        this.histogram = Objects.requireNonNull(histogram, "histogram");
    }

    private ImmutableCommunityCountAndHistogram(ImmutableCommunityCountAndHistogram original, long componentCount, Histogram histogram) {
        this.componentCount = componentCount;
        this.histogram = histogram;
    }

    @Override
    public long componentCount() {
        return this.componentCount;
    }

    @Override
    public Histogram histogram() {
        return this.histogram;
    }

    public final ImmutableCommunityCountAndHistogram withComponentCount(long value) {
        if (this.componentCount == value) {
            return this;
        }
        return new ImmutableCommunityCountAndHistogram(this, value, this.histogram);
    }

    public final ImmutableCommunityCountAndHistogram withHistogram(Histogram value) {
        if (this.histogram == value) {
            return this;
        }
        Histogram newValue = Objects.requireNonNull(value, "histogram");
        return new ImmutableCommunityCountAndHistogram(this, this.componentCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommunityCountAndHistogram && this.equalTo((ImmutableCommunityCountAndHistogram)another);
    }

    private boolean equalTo(ImmutableCommunityCountAndHistogram another) {
        return this.componentCount == another.componentCount && this.histogram.equals((Object)another.histogram);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.componentCount);
        h += (h << 5) + this.histogram.hashCode();
        return h;
    }

    public String toString() {
        return "CommunityCountAndHistogram{componentCount=" + this.componentCount + ", histogram=" + this.histogram + "}";
    }

    public static CommunityStatistics.CommunityCountAndHistogram of(long componentCount, Histogram histogram) {
        return new ImmutableCommunityCountAndHistogram(componentCount, histogram);
    }

    public static CommunityStatistics.CommunityCountAndHistogram copyOf(CommunityStatistics.CommunityCountAndHistogram instance) {
        if (instance instanceof ImmutableCommunityCountAndHistogram) {
            return (ImmutableCommunityCountAndHistogram)instance;
        }
        return ImmutableCommunityCountAndHistogram.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommunityStatistics.CommunityCountAndHistogram", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMPONENT_COUNT = 1L;
        private static final long INIT_BIT_HISTOGRAM = 2L;
        private long initBits = 3L;
        private long componentCount;
        @Nullable
        private Histogram histogram;

        private Builder() {
        }

        public final Builder from(CommunityStatistics.CommunityCountAndHistogram instance) {
            Objects.requireNonNull(instance, "instance");
            this.componentCount(instance.componentCount());
            this.histogram(instance.histogram());
            return this;
        }

        public final Builder componentCount(long componentCount) {
            this.componentCount = componentCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder histogram(Histogram histogram) {
            this.histogram = Objects.requireNonNull(histogram, "histogram");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.componentCount = 0L;
            this.histogram = null;
            return this;
        }

        public CommunityStatistics.CommunityCountAndHistogram build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommunityCountAndHistogram(null, this.componentCount, this.histogram);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("componentCount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("histogram");
            }
            return "Cannot build CommunityCountAndHistogram, some of required attributes are not set " + attributes;
        }
    }
}

