/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.scaling.ScaleProperties;

@ParametersAreNonnullByDefault
@Generated(from="ScaleProperties.Result", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableResult
implements ScaleProperties.Result {
    private final HugeObjectArray<double[]> scaledProperties;

    private ImmutableResult(HugeObjectArray<double[]> scaledProperties) {
        this.scaledProperties = Objects.requireNonNull(scaledProperties, "scaledProperties");
    }

    private ImmutableResult(ImmutableResult original, HugeObjectArray<double[]> scaledProperties) {
        this.scaledProperties = scaledProperties;
    }

    @Override
    public HugeObjectArray<double[]> scaledProperties() {
        return this.scaledProperties;
    }

    public final ImmutableResult withScaledProperties(HugeObjectArray<double[]> value) {
        if (this.scaledProperties == value) {
            return this;
        }
        HugeObjectArray<double[]> newValue = Objects.requireNonNull(value, "scaledProperties");
        return new ImmutableResult(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResult && this.equalTo((ImmutableResult)another);
    }

    private boolean equalTo(ImmutableResult another) {
        return this.scaledProperties.equals(another.scaledProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scaledProperties.hashCode();
        return h;
    }

    public String toString() {
        return "Result{scaledProperties=" + this.scaledProperties + "}";
    }

    public static ScaleProperties.Result of(HugeObjectArray<double[]> scaledProperties) {
        return new ImmutableResult(scaledProperties);
    }

    static ScaleProperties.Result copyOf(ScaleProperties.Result instance) {
        if (instance instanceof ImmutableResult) {
            return (ImmutableResult)instance;
        }
        return ImmutableResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ScaleProperties.Result", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_SCALED_PROPERTIES = 1L;
        private long initBits = 1L;
        @Nullable
        private HugeObjectArray<double[]> scaledProperties;

        private Builder() {
        }

        public final Builder from(ImmutableResult instance) {
            return this.from((ScaleProperties.Result)instance);
        }

        final Builder from(ScaleProperties.Result instance) {
            Objects.requireNonNull(instance, "instance");
            this.scaledProperties(instance.scaledProperties());
            return this;
        }

        public final Builder scaledProperties(HugeObjectArray<double[]> scaledProperties) {
            this.scaledProperties = Objects.requireNonNull(scaledProperties, "scaledProperties");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.scaledProperties = null;
            return this;
        }

        public ScaleProperties.Result build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResult(null, this.scaledProperties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scaledProperties");
            }
            return "Cannot build Result, some of required attributes are not set " + attributes;
        }
    }
}

