/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.scaling.ScalarScaler;

final class L1Norm
extends ScalarScaler {
    final double l1Norm;

    private L1Norm(NodeProperties properties, double l1Norm) {
        super(properties);
        this.l1Norm = l1Norm;
    }

    static ScalarScaler initialize(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)nodeCount, partition -> new ComputeAbsoluteSum((Partition)partition, properties), Optional.empty());
        ParallelUtil.runWithConcurrency((int)concurrency, (Iterable)tasks, (ExecutorService)executor);
        double absoluteSum = tasks.stream().mapToDouble(ComputeAbsoluteSum::sum).sum();
        if (absoluteSum < 1.0E-15) {
            return ZERO;
        }
        return new L1Norm(properties, absoluteSum);
    }

    @Override
    public double scaleProperty(long nodeId) {
        return this.properties.doubleValue(nodeId) / this.l1Norm;
    }

    static class ComputeAbsoluteSum
    extends ScalarScaler.AggregatesComputer {
        private double sum = 0.0;

        ComputeAbsoluteSum(Partition partition, NodeProperties property) {
            super(partition, property);
        }

        @Override
        void compute(long nodeId) {
            this.sum += Math.abs(this.properties.doubleValue(nodeId));
        }

        double sum() {
            return this.sum;
        }
    }
}

