/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.scaling.ScalarScaler;

final class Max
extends ScalarScaler {
    final double maxAbs;

    private Max(NodeProperties properties, double maxAbs) {
        super(properties);
        this.maxAbs = maxAbs;
    }

    static ScalarScaler initialize(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)nodeCount, partition -> new ComputeAbsMax((Partition)partition, properties), Optional.empty());
        ParallelUtil.runWithConcurrency((int)concurrency, (Iterable)tasks, (ExecutorService)executor);
        double absMax = tasks.stream().mapToDouble(ComputeAbsMax::absMax).max().orElse(0.0);
        if (Math.abs(absMax) < 1.0E-15) {
            return ZERO;
        }
        return new Max(properties, absMax);
    }

    @Override
    public double scaleProperty(long nodeId) {
        return this.properties.doubleValue(nodeId) / this.maxAbs;
    }

    static class ComputeAbsMax
    extends ScalarScaler.AggregatesComputer {
        private double absMax = 0.0;

        ComputeAbsMax(Partition partition, NodeProperties property) {
            super(partition, property);
        }

        @Override
        void compute(long nodeId) {
            double absoluteValue = Math.abs(this.properties.doubleValue(nodeId));
            if (absoluteValue > this.absMax) {
                this.absMax = absoluteValue;
            }
        }

        double absMax() {
            return this.absMax;
        }
    }
}

