/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.scaling.ScalarScaler;

final class Mean
extends ScalarScaler {
    final double avg;
    final double maxMinDiff;

    private Mean(NodeProperties properties, double avg, double maxMinDiff) {
        super(properties);
        this.avg = avg;
        this.maxMinDiff = maxMinDiff;
    }

    static ScalarScaler initialize(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)nodeCount, partition -> new ComputeMaxMinSum((Partition)partition, properties), Optional.empty());
        ParallelUtil.runWithConcurrency((int)concurrency, (Iterable)tasks, (ExecutorService)executor);
        double min = tasks.stream().mapToDouble(ComputeMaxMinSum::min).min().orElse(Double.MAX_VALUE);
        double max = tasks.stream().mapToDouble(ComputeMaxMinSum::max).max().orElse(-1.7976931348623157E308);
        double sum = tasks.stream().mapToDouble(ComputeMaxMinSum::sum).sum();
        double maxMinDiff = max - min;
        if (Math.abs(maxMinDiff) < 1.0E-15) {
            return ZERO;
        }
        return new Mean(properties, sum / (double)nodeCount, maxMinDiff);
    }

    @Override
    public double scaleProperty(long nodeId) {
        return (this.properties.doubleValue(nodeId) - this.avg) / this.maxMinDiff;
    }

    static class ComputeMaxMinSum
    extends ScalarScaler.AggregatesComputer {
        private double max = -1.7976931348623157E308;
        private double min = Double.MAX_VALUE;
        private double sum = 0.0;

        ComputeMaxMinSum(Partition partition, NodeProperties property) {
            super(partition, property);
        }

        @Override
        void compute(long nodeId) {
            double propertyValue = this.properties.doubleValue(nodeId);
            this.sum += propertyValue;
            if (propertyValue < this.min) {
                this.min = propertyValue;
            }
            if (propertyValue > this.max) {
                this.max = propertyValue;
            }
        }

        double max() {
            return this.max;
        }

        double min() {
            return this.min;
        }

        double sum() {
            return this.sum;
        }
    }
}

