/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.scaling.L1Norm;
import org.neo4j.gds.scaling.L2Norm;
import org.neo4j.gds.scaling.LogTransformer;
import org.neo4j.gds.scaling.Max;
import org.neo4j.gds.scaling.Mean;
import org.neo4j.gds.scaling.MinMax;
import org.neo4j.gds.scaling.Scaler;
import org.neo4j.gds.scaling.StdScore;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public abstract class ScalarScaler
implements Scaler {
    protected final NodeProperties properties;
    public static final ScalarScaler ZERO = new ScalarScaler(null){

        @Override
        public double scaleProperty(long nodeId) {
            return 0.0;
        }
    };

    public ScalarScaler(NodeProperties properties) {
        this.properties = properties;
    }

    @Override
    public abstract double scaleProperty(long var1);

    @Override
    public int dimension() {
        return 1;
    }

    static abstract class AggregatesComputer
    implements Runnable {
        private final Partition partition;
        final NodeProperties properties;

        AggregatesComputer(Partition partition, NodeProperties property) {
            this.partition = partition;
            this.properties = property;
        }

        @Override
        public void run() {
            long end = this.partition.startNode() + this.partition.nodeCount();
            for (long nodeId = this.partition.startNode(); nodeId < end; ++nodeId) {
                this.compute(nodeId);
            }
        }

        abstract void compute(long var1);
    }

    public static enum Variant {
        NONE{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return new ScalarScaler(properties){

                    @Override
                    public double scaleProperty(long nodeId) {
                        return this.properties.doubleValue(nodeId);
                    }
                };
            }
        }
        ,
        MAX{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return Max.initialize(properties, nodeCount, concurrency, executor);
            }
        }
        ,
        MINMAX{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return MinMax.initialize(properties, nodeCount, concurrency, executor);
            }
        }
        ,
        MEAN{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return Mean.initialize(properties, nodeCount, concurrency, executor);
            }
        }
        ,
        LOG{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return new LogTransformer(properties);
            }
        }
        ,
        STDSCORE{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return StdScore.initialize(properties, nodeCount, concurrency, executor);
            }
        }
        ,
        L1NORM{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return L1Norm.initialize(properties, nodeCount, concurrency, executor);
            }
        }
        ,
        L2NORM{

            @Override
            public ScalarScaler create(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
                return L2Norm.initialize(properties, nodeCount, concurrency, executor);
            }
        };

        private static final List<String> VALUES;

        public static Variant lookup(Object name) {
            if (name instanceof String) {
                String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)name));
                if (VALUES.contains(inputString)) {
                    return Variant.valueOf(inputString);
                }
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Scaler `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{name, StringJoining.join(VALUES)}));
            }
            return (Variant)((Object)name);
        }

        public static String toString(Variant variant) {
            return variant.name();
        }

        public abstract ScalarScaler create(NodeProperties var1, long var2, int var4, ExecutorService var5);

        static {
            VALUES = Arrays.stream(Variant.values()).map(Enum::name).collect(Collectors.toList());
        }
    }
}

