/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.result;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongToDoubleFunction;
import org.HdrHistogram.DoubleHistogram;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.result.CentralityStatistics;
import org.neo4j.gds.result.HistogramUtils;
import org.neo4j.gds.scaling.ScalarScaler;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public abstract class AbstractCentralityResultBuilder<WRITE_RESULT>
extends AbstractResultBuilder<WRITE_RESULT> {
    static final String HISTOGRAM_ERROR_KEY = "Error";
    private final int concurrency;
    private final boolean buildHistogram;
    private final Map<String, Object> histogramError;
    private LongToDoubleFunction centralityFunction;
    private ScalarScaler.Variant scaler;
    protected long postProcessingMillis = -1L;
    protected Map<String, Object> centralityHistogram;

    protected AbstractCentralityResultBuilder(ProcedureCallContext callContext, int concurrency) {
        this.buildHistogram = callContext.outputFields().anyMatch(s -> s.equalsIgnoreCase("centralityDistribution"));
        this.concurrency = concurrency;
        this.histogramError = new HashMap<String, Object>();
    }

    protected abstract WRITE_RESULT buildResult();

    public AbstractCentralityResultBuilder<WRITE_RESULT> withCentralityFunction(LongToDoubleFunction centralityFunction) {
        this.centralityFunction = centralityFunction;
        return this;
    }

    public AbstractCentralityResultBuilder<WRITE_RESULT> withScalerVariant(ScalarScaler.Variant scaler) {
        this.scaler = scaler;
        return this;
    }

    @Override
    public WRITE_RESULT build() {
        ProgressTimer timer = ProgressTimer.start();
        Optional<DoubleHistogram> maybeCentralityHistogram = this.computeCentralityHistogram();
        this.centralityHistogram = this.centralityHistogramResult(maybeCentralityHistogram);
        timer.stop();
        this.postProcessingMillis = timer.getDuration();
        return this.buildResult();
    }

    @NotNull
    private Optional<DoubleHistogram> computeCentralityHistogram() {
        boolean logScaler;
        boolean bl = logScaler = this.scaler == ScalarScaler.Variant.LOG;
        if (this.buildHistogram && this.centralityFunction != null) {
            if (logScaler) {
                this.histogramError.put(HISTOGRAM_ERROR_KEY, "Unable to create histogram when using scaler of type " + ScalarScaler.Variant.LOG);
            } else {
                try {
                    return Optional.of(CentralityStatistics.histogram(this.nodeCount, this.centralityFunction, Pools.DEFAULT, this.concurrency));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (e.getMessage().contains("is out of bounds for histogram, current covered range")) {
                        this.histogramError.put(HISTOGRAM_ERROR_KEY, "Unable to create histogram due to range of scores exceeding implementation limits.");
                    }
                    throw e;
                }
            }
        }
        return Optional.empty();
    }

    private Map<String, Object> centralityHistogramResult(Optional<DoubleHistogram> maybeHistogram) {
        return maybeHistogram.map(HistogramUtils::centralitySummary).orElse(this.histogramError);
    }
}

