/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.result;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.function.LongUnaryOperator;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.result.CommunityStatistics;
import org.neo4j.gds.result.HistogramUtils;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public abstract class AbstractCommunityResultBuilder<WRITE_RESULT>
extends AbstractResultBuilder<WRITE_RESULT> {
    private final ExecutorService executorService;
    private final int concurrency;
    protected boolean buildHistogram;
    protected boolean buildCommunityCount;
    protected long postProcessingDuration = -1L;
    protected OptionalLong maybeCommunityCount = OptionalLong.empty();
    protected Optional<Histogram> maybeCommunityHistogram = Optional.empty();
    private LongUnaryOperator communityFunction = null;

    @Nullable
    protected Map<String, Object> communityHistogramOrNull() {
        return this.maybeCommunityHistogram.map(HistogramUtils::communitySummary).orElse(null);
    }

    protected AbstractCommunityResultBuilder(ProcedureCallContext callContext, int concurrency) {
        this(callContext, Pools.DEFAULT, concurrency);
    }

    protected AbstractCommunityResultBuilder(ProcedureCallContext callContext, ExecutorService executorService, int concurrency) {
        this.buildHistogram = callContext.outputFields().anyMatch(s -> s.equalsIgnoreCase("communityDistribution") || s.equalsIgnoreCase("componentDistribution"));
        this.buildCommunityCount = callContext.outputFields().anyMatch(s -> s.equalsIgnoreCase("communityCount") || s.equalsIgnoreCase("componentCount"));
        this.executorService = executorService;
        this.concurrency = concurrency;
    }

    protected abstract WRITE_RESULT buildResult();

    public AbstractCommunityResultBuilder<WRITE_RESULT> withCommunityFunction(LongUnaryOperator communityFunction) {
        this.communityFunction = communityFunction;
        return this;
    }

    @Override
    public WRITE_RESULT build() {
        ProgressTimer timer = ProgressTimer.start();
        if (this.communityFunction != null) {
            if (this.buildCommunityCount && !this.buildHistogram) {
                this.maybeCommunityCount = OptionalLong.of(CommunityStatistics.communityCount(this.nodeCount, this.communityFunction, this.executorService, this.concurrency));
            } else if (this.buildCommunityCount || this.buildHistogram) {
                CommunityStatistics.CommunityCountAndHistogram communityCountAndHistogram = CommunityStatistics.communityCountAndHistogram(this.nodeCount, this.communityFunction, this.executorService, this.concurrency);
                this.maybeCommunityCount = OptionalLong.of(communityCountAndHistogram.componentCount());
                this.maybeCommunityHistogram = Optional.of(communityCountAndHistogram.histogram());
            }
        }
        timer.stop();
        this.postProcessingDuration = timer.getDuration();
        return this.buildResult();
    }
}

