/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.scaling.ScalarScaler;
import org.neo4j.gds.scaling.ScalePropertiesBaseConfig;

@ParametersAreNonnullByDefault
@Generated(from="ScalePropertiesBaseConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableScalePropertiesBaseConfig
implements ScalePropertiesBaseConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final List<String> nodeProperties;
    private final ScalarScaler.Variant scaler;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableScalePropertiesBaseConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Iterable<String> nodeProperties, ScalarScaler.Variant scaler) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(nodeLabels, true, false)));
        this.nodeProperties = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(nodeProperties, true, false));
        this.scaler = Objects.requireNonNull(scaler, "scaler");
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.initShim = null;
    }

    private ImmutableScalePropertiesBaseConfig(Builder builder) {
        this.nodeProperties = builder.nodeProperties == null ? Collections.emptyList() : ImmutableScalePropertiesBaseConfig.createUnmodifiableList(true, builder.nodeProperties);
        this.scaler = builder.scaler;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableScalePropertiesBaseConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableScalePropertiesBaseConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.initShim = null;
    }

    private ImmutableScalePropertiesBaseConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, List<String> nodeProperties, ScalarScaler.Variant scaler) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.nodeProperties = nodeProperties;
        this.scaler = scaler;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return ScalePropertiesBaseConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return ScalePropertiesBaseConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return ScalePropertiesBaseConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return ScalePropertiesBaseConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return ScalePropertiesBaseConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return ScalePropertiesBaseConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return ScalePropertiesBaseConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return ScalePropertiesBaseConfig.super.nodeLabels();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Override
    public List<String> nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public ScalarScaler.Variant scaler() {
        return this.scaler;
    }

    public final ImmutableScalePropertiesBaseConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(elements, true, false));
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(elements, true, false));
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.nodeProperties, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withNodeProperties(String ... elements) {
        List<String> newValue = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, newValue, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withNodeProperties(Iterable<String> elements) {
        if (this.nodeProperties == elements) {
            return this;
        }
        List<String> newValue = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(elements, true, false));
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, newValue, this.scaler));
    }

    public final ImmutableScalePropertiesBaseConfig withScaler(ScalarScaler.Variant value) {
        if (this.scaler == value) {
            return this;
        }
        ScalarScaler.Variant newValue = Objects.requireNonNull(value, "scaler");
        if (this.scaler.equals((Object)newValue)) {
            return this;
        }
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.nodeProperties, newValue));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScalePropertiesBaseConfig && this.equalTo((ImmutableScalePropertiesBaseConfig)another);
    }

    private boolean equalTo(ImmutableScalePropertiesBaseConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.nodeProperties.equals(another.nodeProperties) && this.scaler.equals((Object)another.scaler);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.nodeProperties.hashCode();
        h += (h << 5) + this.scaler.hashCode();
        return h;
    }

    public String toString() {
        return "ScalePropertiesBaseConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", nodeProperties=" + this.nodeProperties + ", scaler=" + this.scaler + "}";
    }

    public static ScalePropertiesBaseConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, List<String> nodeProperties, ScalarScaler.Variant scaler) {
        return ImmutableScalePropertiesBaseConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, nodeProperties, scaler);
    }

    public static ScalePropertiesBaseConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Iterable<String> nodeProperties, ScalarScaler.Variant scaler) {
        return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, nodeProperties, scaler));
    }

    private static ImmutableScalePropertiesBaseConfig validate(ImmutableScalePropertiesBaseConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static ScalePropertiesBaseConfig copyOf(ScalePropertiesBaseConfig instance) {
        if (instance instanceof ImmutableScalePropertiesBaseConfig) {
            return (ImmutableScalePropertiesBaseConfig)instance;
        }
        return ImmutableScalePropertiesBaseConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ScalePropertiesBaseConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCALER = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private long initBits = 1L;
        private long optBits;
        @javax.annotation.Nullable
        private String usernameOverride;
        private boolean sudo;
        @javax.annotation.Nullable
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private List<String> nodeProperties = null;
        @javax.annotation.Nullable
        private ScalarScaler.Variant scaler;

        private Builder() {
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ScalePropertiesBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ScalePropertiesBaseConfig) {
                instance = (ScalePropertiesBaseConfig)object;
                this.scaler(instance.scaler());
                this.addAllNodeProperties(instance.nodeProperties());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeProperty(String element) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            return this;
        }

        public final Builder addNodeProperties(String ... elements) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            }
            return this;
        }

        public final Builder nodeProperties(Iterable<String> elements) {
            this.nodeProperties = new ArrayList<String>();
            return this.addAllNodeProperties(elements);
        }

        public final Builder addAllNodeProperties(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeProperties element");
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            }
            return this;
        }

        public final Builder scaler(ScalarScaler.Variant scaler) {
            this.scaler = Objects.requireNonNull(scaler, "scaler");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            if (this.nodeProperties != null) {
                this.nodeProperties.clear();
            }
            this.scaler = null;
            return this;
        }

        public ScalePropertiesBaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableScalePropertiesBaseConfig.validate(new ImmutableScalePropertiesBaseConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scaler");
            }
            return "Cannot build ScalePropertiesBaseConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ScalePropertiesBaseConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableScalePropertiesBaseConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableScalePropertiesBaseConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableScalePropertiesBaseConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableScalePropertiesBaseConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableScalePropertiesBaseConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableScalePropertiesBaseConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(ImmutableScalePropertiesBaseConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableScalePropertiesBaseConfig.createUnmodifiableList(false, ImmutableScalePropertiesBaseConfig.createSafeList(ImmutableScalePropertiesBaseConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            return "Cannot build ScalePropertiesBaseConfig, attribute initializers form cycle " + attributes;
        }
    }
}

