/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.scaling.ScalarScaler;

final class L2Norm
extends ScalarScaler {
    final double euclideanLength;

    private L2Norm(NodeProperties properties, double euclideanLength) {
        super(properties);
        this.euclideanLength = euclideanLength;
    }

    static ScalarScaler initialize(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)nodeCount, partition -> new ComputeSquaredSum((Partition)partition, properties), Optional.empty());
        ParallelUtil.runWithConcurrency((int)concurrency, (Iterable)tasks, (ExecutorService)executor);
        double squaredSum = tasks.stream().mapToDouble(ComputeSquaredSum::squaredSum).sum();
        double euclideanLength = Math.sqrt(squaredSum);
        if (euclideanLength < 1.0E-15) {
            return ZERO;
        }
        return new L2Norm(properties, euclideanLength);
    }

    @Override
    public double scaleProperty(long nodeId) {
        return this.properties.doubleValue(nodeId) / this.euclideanLength;
    }

    static class ComputeSquaredSum
    extends ScalarScaler.AggregatesComputer {
        private double squaredSum = 0.0;

        ComputeSquaredSum(Partition partition, NodeProperties property) {
            super(partition, property);
        }

        @Override
        void compute(long nodeId) {
            double propertyValue = this.properties.doubleValue(nodeId);
            this.squaredSum += propertyValue * propertyValue;
        }

        double squaredSum() {
            return this.squaredSum;
        }
    }
}

