/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.scaling.ScalarScaler;

final class MinMax
extends ScalarScaler {
    final double min;
    final double maxMinDiff;

    private MinMax(NodeProperties properties, double min, double maxMinDiff) {
        super(properties);
        this.min = min;
        this.maxMinDiff = maxMinDiff;
    }

    static ScalarScaler initialize(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)nodeCount, partition -> new ComputeMaxMin((Partition)partition, properties), Optional.empty());
        ParallelUtil.runWithConcurrency((int)concurrency, (Iterable)tasks, (ExecutorService)executor);
        double min = tasks.stream().mapToDouble(ComputeMaxMin::min).min().orElse(Double.MAX_VALUE);
        double max = tasks.stream().mapToDouble(ComputeMaxMin::max).max().orElse(-1.7976931348623157E308);
        double maxMinDiff = max - min;
        if (Math.abs(maxMinDiff) < 1.0E-15) {
            return ZERO;
        }
        return new MinMax(properties, min, maxMinDiff);
    }

    @Override
    public double scaleProperty(long nodeId) {
        return (this.properties.doubleValue(nodeId) - this.min) / this.maxMinDiff;
    }

    static class ComputeMaxMin
    extends ScalarScaler.AggregatesComputer {
        private double min = Double.MAX_VALUE;
        private double max = -1.7976931348623157E308;

        ComputeMaxMin(Partition partition, NodeProperties property) {
            super(partition, property);
        }

        @Override
        void compute(long nodeId) {
            double propertyValue = this.properties.doubleValue(nodeId);
            if (propertyValue < this.min) {
                this.min = propertyValue;
            }
            if (propertyValue > this.max) {
                this.max = propertyValue;
            }
        }

        double max() {
            return this.max;
        }

        double min() {
            return this.min;
        }
    }
}

