/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.scaling.ImmutableResult;
import org.neo4j.gds.scaling.ScalarScaler;
import org.neo4j.gds.scaling.ScalePropertiesBaseConfig;
import org.neo4j.gds.scaling.Scaler;
import org.neo4j.gds.utils.StringFormatting;

public class ScaleProperties
extends Algorithm<Result> {
    private final Graph graph;
    private final ScalePropertiesBaseConfig config;
    private final ExecutorService executor;

    public ScaleProperties(Graph graph, ScalePropertiesBaseConfig config, ExecutorService executor) {
        super(ProgressTracker.NULL_TRACKER);
        this.graph = graph;
        this.config = config;
        this.executor = executor;
    }

    @Override
    public Result compute() {
        HugeObjectArray scaledProperties = HugeObjectArray.newArray(double[].class, (long)this.graph.nodeCount());
        List scalers = this.config.nodeProperties().stream().map(this::prepareScalers).collect(Collectors.toList());
        int outputArrayLength = scalers.stream().mapToInt(Scaler::dimension).sum();
        this.initializeArrays((HugeObjectArray<double[]>)scaledProperties, outputArrayLength);
        int resultIndex = 0;
        for (Scaler scaler : scalers) {
            this.scaleProperty((HugeObjectArray<double[]>)scaledProperties, scaler, resultIndex);
            resultIndex += scaler.dimension();
        }
        return Result.of((HugeObjectArray<double[]>)scaledProperties);
    }

    private void initializeArrays(HugeObjectArray<double[]> scaledProperties, int propertyCount) {
        List tasks = PartitionUtils.rangePartition((int)this.config.concurrency(), (long)this.graph.nodeCount(), partition -> () -> partition.consume(nodeId -> scaledProperties.set(nodeId, (Object)new double[propertyCount])), Optional.empty());
        ParallelUtil.runWithConcurrency((int)this.config.concurrency(), (Iterable)tasks, (ExecutorService)this.executor);
    }

    private void scaleProperty(HugeObjectArray<double[]> scaledProperties, Scaler scaler, int index) {
        LongConsumer strategy = this.selectPropertyScalerStrategy(scaledProperties, scaler, index);
        List tasks = PartitionUtils.rangePartition((int)this.config.concurrency(), (long)this.graph.nodeCount(), partition -> () -> partition.consume(strategy), Optional.empty());
        ParallelUtil.runWithConcurrency((int)this.config.concurrency(), (Iterable)tasks, (ExecutorService)this.executor);
    }

    private LongConsumer selectPropertyScalerStrategy(HugeObjectArray<double[]> scaledProperties, Scaler scaler, int index) {
        if (scaler instanceof Scaler.ArrayScaler) {
            return nodeId -> ((Scaler.ArrayScaler)scaler).scaleProperty(nodeId, (double[])scaledProperties.get(nodeId), index);
        }
        return nodeId -> {
            double afterValue = scaler.scaleProperty(nodeId);
            double[] existingResult = (double[])scaledProperties.get(nodeId);
            existingResult[index] = afterValue;
        };
    }

    @Override
    public void release() {
    }

    private Scaler prepareScalers(String propertyName) {
        ScalarScaler.Variant scalerVariant = this.config.scaler();
        NodeProperties nodeProperties = this.graph.nodeProperties(propertyName);
        if (nodeProperties == null) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node property `%s` not found in graph with node properties: %s", (Object[])new Object[]{propertyName, this.graph.availableNodeProperties()}));
        }
        switch (nodeProperties.valueType()) {
            case LONG: 
            case DOUBLE: {
                return scalerVariant.create(nodeProperties, this.graph.nodeCount(), this.config.concurrency(), this.executor);
            }
            case LONG_ARRAY: {
                int arrayLength = nodeProperties.longArrayValue(0L).length;
                List<ScalarScaler> elementScalers = IntStream.range(0, arrayLength).mapToObj(idx -> scalerVariant.create((NodeProperties)this.transformLongArrayEntryToDoubleProperty(propertyName, nodeProperties, arrayLength, idx), this.graph.nodeCount(), this.config.concurrency(), this.executor)).collect(Collectors.toList());
                return new Scaler.ArrayScaler(elementScalers);
            }
            case FLOAT_ARRAY: {
                int arrayLength = nodeProperties.floatArrayValue(0L).length;
                List<ScalarScaler> elementScalers = IntStream.range(0, arrayLength).mapToObj(idx -> scalerVariant.create((NodeProperties)this.transformFloatArrayEntryToDoubleProperty(propertyName, nodeProperties, arrayLength, idx), this.graph.nodeCount(), this.config.concurrency(), this.executor)).collect(Collectors.toList());
                return new Scaler.ArrayScaler(elementScalers);
            }
            case DOUBLE_ARRAY: {
                int arrayLength = nodeProperties.doubleArrayValue(0L).length;
                List<ScalarScaler> elementScalers = IntStream.range(0, arrayLength).mapToObj(idx -> scalerVariant.create((NodeProperties)this.transformDoubleArrayEntryToDoubleProperty(propertyName, nodeProperties, arrayLength, idx), this.graph.nodeCount(), this.config.concurrency(), this.executor)).collect(Collectors.toList());
                return new Scaler.ArrayScaler(elementScalers);
            }
        }
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Scaling node property `%s` of type `%s` is not supported", (Object[])new Object[]{propertyName, nodeProperties.valueType().cypherName()}));
    }

    private DoubleNodeProperties transformFloatArrayEntryToDoubleProperty(final String propertyName, final NodeProperties property, final int expectedArrayLength, final int idx) {
        return new DoubleNodeProperties(){

            public double doubleValue(long nodeId) {
                float[] propertyValue = property.floatArrayValue(nodeId);
                if (propertyValue == null || propertyValue.length != expectedArrayLength) {
                    throw ScaleProperties.this.createInvalidArrayException(propertyName, expectedArrayLength, nodeId, Optional.ofNullable(propertyValue).map(v -> ((float[])v).length).orElse(0));
                }
                return propertyValue[idx];
            }

            public long size() {
                return property.size();
            }
        };
    }

    private DoubleNodeProperties transformDoubleArrayEntryToDoubleProperty(final String propertyName, final NodeProperties property, final int expectedArrayLength, final int idx) {
        return new DoubleNodeProperties(){

            public double doubleValue(long nodeId) {
                double[] propertyValue = property.doubleArrayValue(nodeId);
                if (propertyValue == null || propertyValue.length != expectedArrayLength) {
                    throw ScaleProperties.this.createInvalidArrayException(propertyName, expectedArrayLength, nodeId, Optional.ofNullable(propertyValue).map(v -> ((double[])v).length).orElse(0));
                }
                return propertyValue[idx];
            }

            public long size() {
                return property.size();
            }
        };
    }

    private DoubleNodeProperties transformLongArrayEntryToDoubleProperty(final String propertyName, final NodeProperties property, final int expectedArrayLength, final int idx) {
        return new DoubleNodeProperties(){

            public double doubleValue(long nodeId) {
                long[] propertyValue = property.longArrayValue(nodeId);
                if (propertyValue == null || propertyValue.length != expectedArrayLength) {
                    throw ScaleProperties.this.createInvalidArrayException(propertyName, expectedArrayLength, nodeId, Optional.ofNullable(propertyValue).map(v -> ((long[])v).length).orElse(0));
                }
                return propertyValue[idx];
            }

            public long size() {
                return property.size();
            }
        };
    }

    private IllegalArgumentException createInvalidArrayException(String propertyName, int expectedArrayLength, long nodeId, int actualLength) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"For scaling property `%s` expected array of length %d but got length %d for node %d", (Object[])new Object[]{propertyName, expectedArrayLength, actualLength, nodeId}));
    }

    @ValueClass
    static interface Result {
        public HugeObjectArray<double[]> scaledProperties();

        public static Result of(HugeObjectArray<double[]> properties) {
            return ImmutableResult.of(properties);
        }
    }
}

