/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import org.neo4j.gds.scaling.ScalarScaler;

public interface Scaler {
    public static final double CLOSE_TO_ZERO = 1.0E-15;

    public double scaleProperty(long var1);

    public int dimension();

    public static class ArrayScaler
    implements Scaler {
        private final List<ScalarScaler> elementScalers;

        ArrayScaler(List<ScalarScaler> elementScalers) {
            this.elementScalers = elementScalers;
        }

        public void scaleProperty(long nodeId, double[] result, int offset) {
            for (int i = 0; i < this.dimension(); ++i) {
                result[offset + i] = this.elementScalers.get(i).scaleProperty(nodeId);
            }
        }

        @Override
        public double scaleProperty(long nodeId) {
            throw new UnsupportedOperationException("Use the other scaleProperty method");
        }

        @Override
        public int dimension() {
            return this.elementScalers.size();
        }
    }
}

