/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.scaling.ScalarScaler;

final class StdScore
extends ScalarScaler {
    final double avg;
    final double std;

    private StdScore(NodeProperties properties, double avg, double std) {
        super(properties);
        this.avg = avg;
        this.std = std;
    }

    static ScalarScaler initialize(NodeProperties properties, long nodeCount, int concurrency, ExecutorService executor) {
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)nodeCount, partition -> new ComputeSumAndSquaredSum((Partition)partition, properties), Optional.empty());
        ParallelUtil.runWithConcurrency((int)concurrency, (Iterable)tasks, (ExecutorService)executor);
        double squaredSum = tasks.stream().mapToDouble(ComputeSumAndSquaredSum::squaredSum).sum();
        double sum = tasks.stream().mapToDouble(ComputeSumAndSquaredSum::sum).sum();
        double avg = sum / (double)nodeCount;
        double variance = (squaredSum + avg * ((double)nodeCount * avg - 2.0 * sum)) / (double)nodeCount;
        double std = Math.sqrt(variance);
        if (Math.abs(std) < 1.0E-15) {
            return ZERO;
        }
        return new StdScore(properties, avg, std);
    }

    @Override
    public double scaleProperty(long nodeId) {
        return (this.properties.doubleValue(nodeId) - this.avg) / this.std;
    }

    static class ComputeSumAndSquaredSum
    extends ScalarScaler.AggregatesComputer {
        private double squaredSum = 0.0;
        private double sum = 0.0;

        ComputeSumAndSquaredSum(Partition partition, NodeProperties property) {
            super(partition, property);
        }

        @Override
        void compute(long nodeId) {
            double propertyValue = this.properties.doubleValue(nodeId);
            this.sum += propertyValue;
            this.squaredSum += propertyValue * propertyValue;
        }

        double squaredSum() {
            return this.squaredSum;
        }

        double sum() {
            return this.sum;
        }
    }
}

