/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.gds;

import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public abstract class Algorithm<RESULT> {
    protected final ProgressTracker progressTracker;

    protected TerminationFlag terminationFlag = TerminationFlag.RUNNING_TRUE;

    protected Algorithm(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
    }

    public abstract RESULT compute();

    /**
     * Release internal data structures used by the algorithm.
     *
     */
    public abstract void release();

    public void setTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
    }

    public TerminationFlag getTerminationFlag() {
        return terminationFlag;
    }

    public ProgressTracker getProgressTracker() {
        return this.progressTracker;
    }
}
