/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.test;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.test.TestAlgorithm;
import org.neo4j.gds.test.TestConfig;

public class TestAlgorithmFactory<CONFIG extends TestConfig>
extends GraphAlgorithmFactory<TestAlgorithm, CONFIG> {
    public String taskName() {
        return "TestAlgorithm";
    }

    public TestAlgorithm build(Graph graph, TestConfig configuration, ProgressTracker progressTracker) {
        return new TestAlgorithm(graph, progressTracker, configuration.throwInCompute());
    }

    public MemoryEstimation memoryEstimation(TestConfig configuration) {
        return MemoryEstimations.builder(TestAlgorithm.class).perNode("nodes", l -> l).perGraphDimension("relationships", (dimensions, concurrency) -> MemoryRange.of((long)dimensions.relCountUpperBound())).build();
    }
}

